/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.model.ListDataModel;
import org.ajax4jsf.component.AjaxActionComponent;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.event.DataFilterSliderAdapter;
import org.richfaces.event.DataFilterSliderEvent;
import org.richfaces.event.DataFilterSliderListener;
import org.richfaces.event.DataFilterSliderSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIDataFltrSlider
extends AjaxActionComponent
implements DataFilterSliderSource {
    public static final String COMPONENT_TYPE = "org.richfaces.DataFilterSlider";
    public static final String COMPONENT_FAMILY = "org.richfaces.DataFilterSlider";
    private transient boolean _active = false;
    private transient UIData _UIData;

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void addSliderListener(DataFilterSliderListener listener) {
        this.addFacesListener(listener);
    }

    @Override
    public DataFilterSliderListener[] getSliderListeners() {
        return (DataFilterSliderListener[])this.getFacesListeners(DataFilterSliderListener.class);
    }

    @Override
    public void removeSliderListener(DataFilterSliderListener listener) {
        this.removeFacesListener(listener);
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof DataFilterSliderEvent && this.getSliderListeners().length < 1) {
            this.addSliderListener(new DataFilterSliderAdapter(this.getSliderListener()));
        }
        super.broadcast(event);
    }

    @Override
    protected void setupReRender(FacesContext context) {
        super.setupReRender(context);
        AjaxRendererUtils.addRegionByName(context, this, this.getId());
        String forAttr = this.getFor();
        RendererUtils rendUtil = RendererUtils.getInstance();
        if (forAttr != null) {
            AjaxRendererUtils.addRegionByName(context, this, rendUtil.correctForIdReference(forAttr, this));
        }
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.decode(context);
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        try {
            this.updateModel(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    protected void updateModel(FacesContext context) {
        ValueExpression ve;
        Integer handleValue = this.getHandleValue();
        if (null != handleValue && (ve = this.getValueExpression("handleValue")) != null) {
            try {
                ve.setValue(context.getELContext(), handleValue);
                this.setHandleValue(null);
            }
            catch (ELException e) {
                Throwable result;
                String messageStr = e.getMessage();
                for (result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                    messageStr = result.getMessage();
                }
                FacesMessage message = null == messageStr ? MessageUtil.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)}) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                context.getExternalContext().log(message.getSummary(), result);
                context.addMessage(this.getClientId(context), message);
                context.renderResponse();
            }
            catch (IllegalArgumentException e) {
                FacesMessage message = MessageUtil.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)});
                context.getExternalContext().log(message.getSummary(), e);
                context.addMessage(this.getClientId(context), message);
                context.renderResponse();
            }
            catch (Exception e) {
                FacesMessage message = MessageUtil.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)});
                context.getExternalContext().log(message.getSummary(), e);
                context.addMessage(this.getClientId(context), message);
                context.renderResponse();
            }
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    private Map<String, Object> getSession() {
        return this.getFacesContext().getExternalContext().getSessionMap();
    }

    public UIData getUIData() {
        ArrayList ajaxSliderList = (ArrayList)this.getSession().get("UISliderList");
        this._UIData = this.getDataTable();
        if (ajaxSliderList == null) {
            ListDataModel ajaxSliderLDM = new ListDataModel();
            ajaxSliderLDM.setWrappedData(this._UIData.getValue());
            this.getSession().put("UISliderList", ajaxSliderLDM.getWrappedData());
        } else {
            this._UIData.setValue(ajaxSliderList);
        }
        return this._UIData;
    }

    protected UIData getDataTable() {
        String forAttribute = this.getFor();
        UIComponent forComp = forAttribute == null ? this.getParent() : RendererUtils.getInstance().findComponentFor(this, forAttribute);
        if (forComp == null) {
            throw new IllegalArgumentException("could not find dataTable with id '" + forAttribute + "'. If you are outside the naming container, try prepending the form name like for=\"form1:tableName\"");
        }
        if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException("component with id '" + forAttribute + "' must be of type " + UIData.class.getName() + ", not type " + forComp.getClass().getName());
        }
        return (UIData)forComp;
    }

    public void resetDataTable() {
        this.getSession().remove("UISliderList");
        this.getDataTable().setValue(this.getDataTable().getValueBinding("#{" + this.getForValRef() + "}"));
    }

    public void filterDataTable(int sliderVal) {
        UIData dataTable = this.getUIData();
        ArrayList filteredDataTable = new ArrayList();
        ArrayList dataTableList = (ArrayList)dataTable.getValue();
        for (int i = 0; i < dataTableList.size(); ++i) {
            Object o = dataTableList.get(i);
            try {
                int objectVal;
                String filterByString = o.getClass().getMethod(this.getFilterBy(), null).invoke(o, null).toString();
                if (filterByString.indexOf(".") > 0) {
                    filterByString = filterByString.substring(0, filterByString.indexOf("."));
                }
                if ((objectVal = Integer.parseInt(filterByString)) >= sliderVal) continue;
                filteredDataTable.add(o);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getDataTable().setValue(filteredDataTable);
    }

    public String getSliderRange() {
        String sliderValues = "";
        Integer startRange = this.getStartRange();
        Integer endRange = this.getEndRange();
        Integer increment = this.getIncrement();
        if (startRange != null && endRange != null && increment != null) {
            int segmentTotalStart;
            int segmentTotal;
            if (this.getStartRange() == 0) {
                segmentTotal = this.getEndRange() / this.getIncrement();
                segmentTotalStart = 0;
            } else {
                segmentTotal = this.getEndRange() / this.getIncrement() - 1;
                segmentTotalStart = this.getStartRange();
            }
            int j = segmentTotalStart;
            for (int i = segmentTotalStart; i <= segmentTotal; ++i) {
                if (i != 0) {
                    if (i != j) {
                        j += this.getIncrement().intValue();
                    }
                } else {
                    j = this.getStartRange();
                }
                sliderValues = i == segmentTotal ? sliderValues + this.getEndRange() : sliderValues + j + ",";
            }
        }
        return sliderValues;
    }

    public abstract void setSliderListener(MethodBinding var1);

    public abstract MethodBinding getSliderListener();

    public abstract String getTrackStyleClass();

    public abstract void setTrackStyleClass(String var1);

    public abstract boolean isSubmitOnSlide();

    public abstract void setSubmitOnSlide(boolean var1);

    public abstract boolean isStoreResults();

    public abstract void setStoreResults(boolean var1);

    public abstract String getForValRef();

    public abstract void setForValRef(String var1);

    public abstract String getFilterBy();

    public abstract void setFilterBy(String var1);

    public abstract String getFor();

    public abstract void setFor(String var1);

    public abstract void setStyleClass(String var1);

    public abstract String getStyleClass();

    public abstract void setFieldStyleClass(String var1);

    public abstract String getFieldStyleClass();

    public abstract Integer getStartRange();

    public abstract void setStartRange(Integer var1);

    public abstract Integer getEndRange();

    public abstract void setEndRange(Integer var1);

    public abstract Integer getIncrement();

    public abstract void setIncrement(Integer var1);

    public abstract String getRangeStyleClass();

    public abstract void setRangeStyleClass(String var1);

    public abstract boolean isTrailer();

    public abstract void setTrailer(boolean var1);

    public abstract String getTrailerStyleClass();

    public abstract void setTrailerStyleClass(String var1);

    public abstract String getHandleStyleClass();

    public abstract void setHandleStyleClass(String var1);

    public abstract Integer getHandleValue();

    public abstract void setHandleValue(Integer var1);

    public abstract boolean isManualInput();

    public abstract void setManualInput(boolean var1);

    @Override
    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    public void decode(FacesContext context) {
        super.decode(context);
    }
}

