/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import com.google.common.collect.Iterables;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.component.AbstractTree;
import org.richfaces.component.ComponentPredicates;
import org.richfaces.component.TreeModelAdaptor;
import org.richfaces.component.TreeModelRecursiveAdaptor;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.model.DeclarativeModelKey;
import org.richfaces.model.SequenceRowKey;

public class DeclarativeTreeDataModelWalker {
    private static final Logger LOGGER = RichfacesLogger.COMPONENTS.getLogger();
    private String var;
    private FacesContext facesContext;
    private UIComponent rootComponent;
    private UIComponent currentComponent;
    private Map<String, Object> contextMap;
    private Object modelData;
    private Object data;

    public DeclarativeTreeDataModelWalker(FacesContext facesContext, AbstractTree rootComponent) {
        this.rootComponent = rootComponent;
        this.facesContext = facesContext;
        this.contextMap = rootComponent.getVariablesMap(facesContext);
        this.var = rootComponent.getVar();
        this.currentComponent = rootComponent;
    }

    private void setupModelComponentContext(String modelId) {
        if (this.currentComponent instanceof TreeModelRecursiveAdaptor && modelId.equals(this.currentComponent.getId())) {
            this.modelData = ((TreeModelRecursiveAdaptor)((Object)this.currentComponent)).getNodes();
        } else {
            this.currentComponent = Iterables.find(this.currentComponent.getChildren(), ComponentPredicates.withId(modelId));
            this.modelData = this.currentComponent instanceof TreeModelRecursiveAdaptor ? ((TreeModelRecursiveAdaptor)((Object)this.currentComponent)).getRoots() : ((TreeModelAdaptor)((Object)this.currentComponent)).getNodes();
        }
    }

    private void setupDataModelContext(Object key) {
        if (this.modelData instanceof Iterable) {
            Iterable iterable = (Iterable)this.modelData;
            Integer index = (Integer)key;
            this.data = index < Iterables.size(iterable) ? Iterables.get(iterable, index) : null;
        } else {
            this.data = ((Map)this.modelData).get(key);
        }
    }

    private void resetForDataNotAvailable() {
        this.data = null;
        this.currentComponent = this.rootComponent;
    }

    protected FacesContext getFacesContext() {
        return this.facesContext;
    }

    protected UIComponent getRootComponent() {
        return this.rootComponent;
    }

    public UIComponent getCurrentComponent() {
        return this.currentComponent;
    }

    public Object getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walk(SequenceRowKey key) {
        Object initialContextValue = null;
        if (this.var != null) {
            initialContextValue = this.contextMap.remove(this.var);
        }
        try {
            for (Object simpleKey : key.getSimpleKeys()) {
                DeclarativeModelKey declarativeKey = (DeclarativeModelKey)simpleKey;
                if (this.var != null) {
                    this.contextMap.put(this.var, this.data);
                }
                this.setupModelComponentContext(declarativeKey.getModelId());
                if (this.modelData == null) {
                    this.resetForDataNotAvailable();
                } else {
                    this.setupDataModelContext(declarativeKey.getModelKey());
                    if (this.data != null) continue;
                    this.resetForDataNotAvailable();
                }
                break;
            }
        }
        finally {
            if (this.var != null) {
                try {
                    this.contextMap.put(this.var, initialContextValue);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
        }
    }
}

