/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.component.ListType;
import org.richfaces.component.UISequence;
import org.richfaces.component.attribute.CoreProps;
import org.richfaces.component.attribute.EventsKeyProps;
import org.richfaces.component.attribute.EventsMouseProps;
import org.richfaces.component.attribute.EventsRowProps;
import org.richfaces.component.attribute.I18nProps;
import org.richfaces.component.attribute.IterationProps;
import org.richfaces.component.attribute.RowsProps;
import org.richfaces.component.attribute.SequenceProps;

public abstract class AbstractList
extends UISequence
implements CoreProps,
EventsKeyProps,
EventsMouseProps,
EventsRowProps,
I18nProps,
RowsProps,
SequenceProps,
IterationProps {
    public static final String TERM = "term";
    private static final Predicate<String> TERM_PREDICATE = new Predicate<String>(){

        @Override
        public boolean apply(String input) {
            return AbstractList.TERM.equals(input);
        }
    };
    private static final Predicate<String> NON_TERM_PREDICATE = Predicates.not(TERM_PREDICATE);

    private Iterator<UIComponent> getFacetsIterator(Predicate<? super String> namePredicate) {
        if (this.getFacetCount() > 0) {
            return Maps.filterKeys(this.getFacets(), namePredicate).values().iterator();
        }
        return ImmutableSet.of().iterator();
    }

    @Override
    protected Iterator<UIComponent> dataChildren() {
        return Iterators.concat(this.getChildren().iterator(), this.getFacetsIterator(TERM_PREDICATE));
    }

    @Override
    protected Iterator<UIComponent> fixedChildren() {
        return this.getFacetsIterator(NON_TERM_PREDICATE);
    }

    @Attribute(defaultValue="ListType.unordered")
    public abstract ListType getType();

    public UIComponent getTerm() {
        return this.getFacet(TERM);
    }

    @Attribute
    public abstract String getRowClasses();

    @Attribute
    public abstract String getRowClass();
}

