/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.servlet.jsp.jstl.sql.Result;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.component.attribute.AutocompleteProps;
import org.richfaces.component.attribute.CoreProps;
import org.richfaces.component.attribute.DisabledProps;
import org.richfaces.component.attribute.EventsKeyProps;
import org.richfaces.component.attribute.EventsMouseProps;
import org.richfaces.component.attribute.FocusProps;
import org.richfaces.component.attribute.StyleClassProps;
import org.richfaces.component.attribute.StyleProps;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.renderkit.MetaComponentRenderer;

public abstract class AbstractAutocomplete
extends UIInput
implements MetaComponentResolver,
MetaComponentEncoder,
DisabledProps,
FocusProps,
EventsKeyProps,
EventsMouseProps,
StyleClassProps,
StyleProps,
AutocompleteProps,
CoreProps {
    public static final String ITEMS_META_COMPONENT_ID = "items";
    public static final String COMPONENT_TYPE = "org.richfaces.Autocomplete";
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    private static final Logger LOGGER = RichfacesLogger.COMPONENTS.getLogger();

    @Attribute(literal=false)
    public abstract Object getFetchValue();

    @Attribute(defaultValue="rf-au-itm-sel")
    public abstract String getSelectedItemClass();

    @Attribute
    public abstract String getPopupClass();

    @Attribute
    public abstract String getInputClass();

    @Attribute
    public abstract String getLayout();

    @Attribute
    public abstract String getTokens();

    @Attribute(defaultValue="true")
    public abstract boolean isAutofill();

    @Attribute
    public abstract boolean isShowButton();

    @Attribute(defaultValue="true")
    public abstract boolean isSelectFirst();

    @Attribute
    public abstract String getClientFilterFunction();

    @Attribute(events={@EventName(value="selectitem")})
    public abstract String getOnselectitem();

    @Attribute(events={@EventName(value="change", defaultEvent=true)})
    public abstract String getOnchange();

    @Attribute(events={@EventName(value="listclick")})
    public abstract String getOnlistclick();

    @Attribute(events={@EventName(value="listdblclick")})
    public abstract String getOnlistdblclick();

    @Attribute(events={@EventName(value="listmousedown")})
    public abstract String getOnlistmousedown();

    @Attribute(events={@EventName(value="listmouseup")})
    public abstract String getOnlistmouseup();

    @Attribute(events={@EventName(value="listmouseover")})
    public abstract String getOnlistmouseover();

    @Attribute(events={@EventName(value="listmousemove")})
    public abstract String getOnlistmousemove();

    @Attribute(events={@EventName(value="listmouseout")})
    public abstract String getOnlistmouseout();

    @Attribute(events={@EventName(value="listkeypress")})
    public abstract String getOnlistkeypress();

    @Attribute(events={@EventName(value="listkeydown")})
    public abstract String getOnlistkeydown();

    @Attribute(events={@EventName(value="listkeyup")})
    public abstract String getOnlistkeyup();

    @Attribute(events={@EventName(value="begin")})
    public abstract String getOnbegin();

    @Attribute(events={@EventName(value="complete")})
    public abstract String getOncomplete();

    @Attribute(events={@EventName(value="beforedomupdate")})
    public abstract String getOnbeforedomupdate();

    public DataModel<Object> getItems(FacesContext facesContext, String value) {
        return AbstractAutocomplete.getItems(facesContext, this, value);
    }

    public static DataModel<Object> getItems(FacesContext facesContext, UIComponent component, String value) {
        DataModel result;
        if (!(component instanceof AutocompleteProps)) {
            return null;
        }
        AutocompleteProps autocomplete = (AutocompleteProps)((Object)component);
        Object itemsObject = null;
        MethodExpression autocompleteMethod = autocomplete.getAutocompleteMethod();
        if (autocompleteMethod != null) {
            try {
                try {
                    itemsObject = autocompleteMethod.invoke(facesContext.getELContext(), new Object[]{facesContext, component, value});
                }
                catch (MethodNotFoundException e1) {
                    try {
                        itemsObject = autocomplete.getAutocompleteMethodWithOneParameter().invoke(facesContext.getELContext(), new Object[]{value});
                    }
                    catch (MethodNotFoundException e2) {
                        ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
                        autocompleteMethod = expressionFactory.createMethodExpression(facesContext.getELContext(), autocompleteMethod.getExpressionString(), Object.class, new Class[]{String.class});
                        itemsObject = autocompleteMethod.invoke(facesContext.getELContext(), new Object[]{value});
                    }
                }
            }
            catch (ELException ee) {
                LOGGER.error(ee.getMessage(), ee);
            }
        } else {
            itemsObject = autocomplete.getAutocompleteList();
        }
        if (itemsObject instanceof Object[]) {
            result = new ArrayDataModel<Object>((Object[])itemsObject);
        } else if (itemsObject instanceof List) {
            result = new ListDataModel((List)itemsObject);
        } else if (itemsObject instanceof Result) {
            result = new ResultDataModel((Result)itemsObject);
        } else if (itemsObject instanceof ResultSet) {
            result = new ResultSetDataModel((ResultSet)itemsObject);
        } else if (itemsObject != null) {
            ArrayList temp = new ArrayList();
            Iterator iterator = ((Iterable)itemsObject).iterator();
            while (iterator.hasNext()) {
                temp.add(iterator.next());
            }
            result = new ListDataModel(temp);
        } else {
            result = new ListDataModel();
        }
        return result;
    }

    @Override
    public String resolveClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        if (ITEMS_META_COMPONENT_ID.equals(metaComponentId)) {
            return this.getClientId(facesContext) + '@' + metaComponentId;
        }
        return null;
    }

    @Override
    public String substituteUnresolvedClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        return null;
    }

    @Override
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        ExtendedVisitContext extendedVisitContext;
        if (context instanceof ExtendedVisitContext && (extendedVisitContext = (ExtendedVisitContext)context).getVisitMode() == ExtendedVisitContextMode.RENDER) {
            VisitResult result = extendedVisitContext.invokeMetaComponentVisitCallback(this, callback, ITEMS_META_COMPONENT_ID);
            if (result == VisitResult.COMPLETE) {
                return true;
            }
            if (result == VisitResult.REJECT) {
                return false;
            }
        }
        return super.visitTree(context, callback);
    }

    @Override
    public void encodeMetaComponent(FacesContext context, String metaComponentId) throws IOException {
        ((MetaComponentRenderer)((Object)this.getRenderer(context))).encodeMetaComponent(context, this, metaComponentId);
    }
}

