/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdi.push;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import org.richfaces.application.push.MessageException;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.TopicsContext;
import org.richfaces.cdi.push.Push;
import org.richfaces.cdi.push.PushCDIMessageException;
import org.richfaces.cdi.push.TopicKeyResolver;

public class PushCDIExtension
implements Extension {
    private Set<Push> pushAnnotations = new LinkedHashSet<Push>();

    public void processInjectionTarget(@Observes ProcessInjectionTarget<?> pit) {
        this.scanForPushAnnotations(pit.getInjectionTarget().getInjectionPoints());
    }

    private void scanForPushAnnotations(Collection<InjectionPoint> injectionPoints) {
        for (InjectionPoint injectionPoint : injectionPoints) {
            Push pushAnnotation = injectionPoint.getAnnotated().getAnnotation(Push.class);
            if (pushAnnotation == null) continue;
            this.pushAnnotations.add(pushAnnotation);
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        for (Push pushAnnotation : this.pushAnnotations) {
            event.addObserverMethod(new PushObserverMethod(beanManager, pushAnnotation));
        }
    }

    private static class PushObserverMethod
    implements ObserverMethod<Object> {
        private BeanManager beanManager;
        private Push pushAnnotation;

        public PushObserverMethod(BeanManager beanManager, Push pushAnnotation) {
            this.beanManager = beanManager;
            this.pushAnnotation = pushAnnotation;
        }

        @Override
        public void notify(Object payload) {
            TopicsContext topicsContext = this.getBeanReference(TopicsContext.class);
            TopicKeyResolver topicKeyResolver = this.getBeanReference(TopicKeyResolver.class);
            TopicKey topicKey = topicKeyResolver.resolveTopicKey(this.pushAnnotation);
            try {
                topicsContext.publish(topicKey, payload);
            }
            catch (MessageException e) {
                throw new PushCDIMessageException("Message wasn't successfully deliver", e);
            }
        }

        @Override
        public Class<?> getBeanClass() {
            return PushObserverMethod.class;
        }

        @Override
        public Type getObservedType() {
            return Object.class;
        }

        @Override
        public Set<Annotation> getObservedQualifiers() {
            return new HashSet<Annotation>(Arrays.asList(this.pushAnnotation));
        }

        @Override
        public Reception getReception() {
            return Reception.IF_EXISTS;
        }

        @Override
        public TransactionPhase getTransactionPhase() {
            return TransactionPhase.IN_PROGRESS;
        }

        private <T> T getBeanReference(Class<T> beanType) {
            Set<Bean<?>> beans = this.beanManager.getBeans(beanType, new Annotation[0]);
            Bean<?> bean = beans.iterator().next();
            CreationalContext<?> ctx = this.beanManager.createCreationalContext(bean);
            Object reference = this.beanManager.getReference(bean, beanType, ctx);
            return (T)reference;
        }
    }
}

