/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.richfaces.util.FastJoiner;

public class TopicKey
implements Serializable {
    public static final char SUBCHANNEL_SEPARATOR = '@';
    private static final long serialVersionUID = -6967010810728932698L;
    private static final Pattern NAME_PATTERN = Pattern.compile("([a-zA-Z0-9_]+|#\\{.+\\})");
    private static final FastJoiner AT_JOINER = FastJoiner.on('@');
    private final String topicName;
    private final String subtopicName;
    private static final Function<String, TopicKey> FACTORY = new Function<String, TopicKey>(){

        @Override
        public TopicKey apply(String from) {
            return new TopicKey(from);
        }
    };
    private static final Function<TopicKey, String> TO_ADDRESS = new Function<TopicKey, String>(){

        @Override
        public String apply(TopicKey from) {
            return from.getTopicAddress();
        }
    };

    public TopicKey(String topicAddress) {
        this(TopicKey.getTopicName(topicAddress), TopicKey.getSubtopicName(topicAddress));
    }

    public TopicKey(String topicName, String subtopicName) {
        if (topicName == null) {
            throw new NullPointerException();
        }
        this.topicName = topicName;
        this.subtopicName = subtopicName;
        if (!NAME_PATTERN.matcher(topicName).matches()) {
            throw new IllegalArgumentException("Topic name '" + topicName + "' does not match pattern " + NAME_PATTERN.pattern());
        }
        if (subtopicName != null && !NAME_PATTERN.matcher(subtopicName).matches()) {
            throw new IllegalArgumentException("Subtopic name '" + subtopicName + "' does not match pattern " + NAME_PATTERN.pattern());
        }
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getSubtopicName() {
        return this.subtopicName;
    }

    public String getTopicAddress() {
        return AT_JOINER.join(this.subtopicName, this.topicName);
    }

    public TopicKey getRootTopicKey() {
        if (this.getSubtopicName() == null) {
            return this;
        }
        return new TopicKey(this.getTopicName(), null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subtopicName == null ? 0 : this.subtopicName.hashCode());
        result = 31 * result + (this.topicName == null ? 0 : this.topicName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicKey other = (TopicKey)obj;
        if (this.subtopicName == null ? other.subtopicName != null : !this.subtopicName.equals(other.subtopicName)) {
            return false;
        }
        return !(this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName));
    }

    public String toString() {
        return "TopicKey[" + TO_ADDRESS.apply(this) + "]";
    }

    private static String getTopicName(String topicAddress) {
        int idx = topicAddress.indexOf(64);
        if (idx < 0) {
            return topicAddress;
        }
        return topicAddress.substring(idx + 1);
    }

    private static String getSubtopicName(String topicAddress) {
        int idx = topicAddress.indexOf(64);
        if (idx < 0) {
            return null;
        }
        return topicAddress.substring(0, idx);
    }

    public static Function<String, TopicKey> factory() {
        return FACTORY;
    }

    public static Function<TopicKey, String> toAddress() {
        return TO_ADDRESS;
    }
}

