/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import org.richfaces.application.Initializable;
import org.richfaces.application.Module;
import org.richfaces.application.ServiceException;
import org.richfaces.application.ServicesFactory;

public class ServicesFactoryImpl
implements ServicesFactory {
    private ClassToInstanceMap<Object> instances;

    @Override
    public <T> T getInstance(Class<T> type) throws ServiceException {
        return this.instances.getInstance(type);
    }

    @Override
    public <T> void setInstance(Class<T> type, T instance) {
        this.instances.putInstance(type, instance);
    }

    public void init(Iterable<Module> modules) {
        this.instances = MutableClassToInstanceMap.create();
        for (Module module : modules) {
            module.configure(this);
        }
        for (Module service : this.instances.values()) {
            if (!(service instanceof Initializable)) continue;
            Initializable initializableService = (Initializable)((Object)service);
            initializableService.init();
        }
        this.instances = ImmutableClassToInstanceMap.copyOf(this.instances);
    }

    @Override
    public void release() {
        for (Object service : this.instances.values()) {
            if (!(service instanceof Initializable)) continue;
            Initializable initializableService = (Initializable)service;
            initializableService.release();
        }
        this.instances = null;
    }
}

