/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.resource.GifRenderer;
import org.ajax4jsf.resource.HTMLRenderer;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.JarResource;
import org.ajax4jsf.resource.JpegRenderer;
import org.ajax4jsf.resource.LogfileRenderer;
import org.ajax4jsf.resource.MimeRenderer;
import org.ajax4jsf.resource.PngRenderer;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.resource.ResourceRenderer;
import org.ajax4jsf.resource.ScriptRenderer;
import org.ajax4jsf.resource.StaticResource;
import org.ajax4jsf.resource.StyleRenderer;
import org.ajax4jsf.resource.TemplateCSSRenderer;
import org.ajax4jsf.resource.UserResource;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.ajax4jsf.util.base64.Codec;
import org.ajax4jsf.webapp.WebXml;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBuilderImpl
extends InternetResourceBuilder {
    private static final Log log = LogFactory.getLog(ResourceBuilderImpl.class);
    private static final String DATA_SEPARATOR = "/DATA/";
    private static final String DATA_BYTES_SEPARATOR = "/DATB/";
    private static final Pattern DATA_SEPARATOR_PATTERN = Pattern.compile("/DAT(A|B)/");
    private static final ResourceRenderer defaultRenderer = new MimeRenderer(null);
    private Map<String, ResourceRenderer> renderers;
    private Map<String, InternetResource> resources = Collections.synchronizedMap(new HashMap());
    private long _startTime = System.currentTimeMillis();
    private Codec codec = new Codec();
    private static final ResourceRenderer scriptRenderer = new ScriptRenderer();
    private static final ResourceRenderer styleRenderer = new StyleRenderer();

    public WebXml getWebXml(FacesContext context) {
        WebXml webXml = WebXml.getInstance(context);
        if (null == webXml) {
            throw new FacesException("Resources framework is not initialised, check web.xml for Filter configuration");
        }
        return webXml;
    }

    public ResourceBuilderImpl() {
        this.renderers = new HashMap<String, ResourceRenderer>();
        this.renderers.put(".gif", new GifRenderer());
        JpegRenderer renderer = new JpegRenderer();
        this.renderers.put(".jpeg", renderer);
        this.renderers.put(".jpg", renderer);
        this.renderers.put(".png", new PngRenderer());
        this.renderers.put(".js", this.getScriptRenderer());
        this.renderers.put(".css", this.getStyleRenderer());
        this.renderers.put(".log", new LogfileRenderer());
        this.renderers.put(".html", new HTMLRenderer());
        this.renderers.put(".xhtml", new MimeRenderer("application/xhtml+xml"));
        this.renderers.put(".xml", new MimeRenderer("text/xml"));
        this.renderers.put(".xcss", new TemplateCSSRenderer());
        this.renderers.put(".swf", new MimeRenderer("application/x-shockwave-flash"));
    }

    protected void registerResources() throws FacesException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> e = loader.getResources("META-INF/resources-config.xml");
            while (e.hasMoreElements()) {
                URL resource = e.nextElement();
                this.registerConfig(resource);
            }
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerConfig(URL resourceConfig) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Process resources configuration file " + resourceConfig.toExternalForm());
            }
            InputStream in = URLToStreamHelper.urlToStream(resourceConfig);
            try {
                Digester digester = new Digester();
                digester.setValidating(false);
                digester.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        return new InputSource(new StringReader(""));
                    }
                });
                digester.setNamespaceAware(false);
                digester.setUseContextClassLoader(true);
                digester.push(this);
                digester.addObjectCreate("resource-config/resource", "class", JarResource.class);
                digester.addObjectCreate("resource-config/resource/renderer", "class", HTMLRenderer.class);
                digester.addCallMethod("resource-config/resource/renderer/content-type", "setContentType", 0);
                digester.addSetNext("resource-config/resource/renderer", "setRenderer", ResourceRenderer.class.getName());
                digester.addCallMethod("resource-config/resource/name", "setKey", 0);
                digester.addCallMethod("resource-config/resource/path", "setPath", 0);
                digester.addCallMethod("resource-config/resource/cacheable", "setCacheable", 0);
                digester.addCallMethod("resource-config/resource/session-aware", "setSessionAware", 0);
                digester.addCallMethod("resource-config/resource/property", "setProperty", 2);
                digester.addCallParam("resource-config/resource/property/name", 0);
                digester.addCallParam("resource-config/resource/property/value", 1);
                digester.addCallMethod("resource-config/resource/content-type", "setContentType", 0);
                digester.addSetNext("resource-config/resource", "addResource", InternetResource.class.getName());
                digester.parse(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        catch (SAXException e) {
            throw new FacesException(e);
        }
    }

    @Override
    public void init() throws FacesException {
        this.registerResources();
    }

    @Override
    public InternetResource createResource(Object base, String path) throws FacesException {
        try {
            return this.getResource(path);
        }
        catch (ResourceNotFoundException e) {
            try {
                return this.getResource(this.buildKey(base, path));
            }
            catch (ResourceNotFoundException e1) {
                InternetResource res;
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("BUILD_RESOURCE_INFO", path));
                }
                try {
                    Class<?> resourceClass = Class.forName(path);
                    res = this.createDynamicResource(path, resourceClass);
                }
                catch (Exception e2) {
                    try {
                        res = this.createJarResource(base, path);
                    }
                    catch (ResourceNotFoundException ex) {
                        res = this.createStaticResource(path);
                    }
                }
                return res;
            }
        }
    }

    private String buildKey(Object base, String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        if (null == base) {
            return path;
        }
        StringBuffer packageName = new StringBuffer(base.getClass().getPackage().getName().replace('.', '/'));
        return packageName.append("/").append(path).toString();
    }

    @Override
    public String getUri(InternetResource resource, FacesContext context, Object storeData) {
        StringBuffer uri = new StringBuffer();
        uri.append(resource.getKey());
        if (storeData != null) {
            try {
                byte[] objectData;
                if (storeData instanceof byte[]) {
                    objectData = (byte[])storeData;
                    uri.append(DATA_BYTES_SEPARATOR);
                } else {
                    ByteArrayOutputStream dataSteram = new ByteArrayOutputStream(1024);
                    ObjectOutputStream objStream = new ObjectOutputStream(dataSteram);
                    objStream.writeObject(storeData);
                    objStream.flush();
                    objStream.close();
                    dataSteram.close();
                    objectData = dataSteram.toByteArray();
                    uri.append(DATA_SEPARATOR);
                }
                byte[] dataArray = this.encrypt(objectData);
                uri.append(new String(dataArray, "ISO-8859-1"));
            }
            catch (Exception e) {
                log.error(Messages.getMessage("QUERY_STRING_BUILDING_ERROR"), e);
            }
        }
        boolean isGlobal = !resource.isSessionAware();
        String resourceURL = this.getWebXml(context).getFacesResourceURL(context, uri.toString(), isGlobal);
        if (!isGlobal) {
            resourceURL = context.getExternalContext().encodeResourceURL(resourceURL);
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("BUILD_RESOURCE_URI_INFO", resource.getKey(), resourceURL));
        }
        return resourceURL;
    }

    @Override
    public InternetResource getResourceForKey(String key) throws ResourceNotFoundException {
        Matcher matcher = DATA_SEPARATOR_PATTERN.matcher(key);
        if (matcher.find()) {
            int data = matcher.start();
            key = key.substring(0, data);
        }
        return this.getResource(key);
    }

    @Override
    public Object getResourceDataForKey(String key) {
        Object data = null;
        String dataString = null;
        Matcher matcher = DATA_SEPARATOR_PATTERN.matcher(key);
        if (matcher.find()) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("RESTORE_DATA_FROM_RESOURCE_URI_INFO", key, dataString));
            }
            int dataStart = matcher.end();
            dataString = key.substring(dataStart);
            byte[] objectArray = null;
            try {
                byte[] dataArray = dataString.getBytes("ISO-8859-1");
                objectArray = this.decrypt(dataArray);
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
            if ("B".equals(matcher.group(1))) {
                data = objectArray;
            } else {
                try {
                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(objectArray));
                    data = in.readObject();
                }
                catch (StreamCorruptedException e) {
                    log.error(Messages.getMessage("STREAM_CORRUPTED_ERROR"), e);
                }
                catch (IOException e) {
                    log.error(Messages.getMessage("DESERIALIZE_DATA_INPUT_ERROR"), e);
                }
                catch (ClassNotFoundException e) {
                    log.error(Messages.getMessage("DATA_CLASS_NOT_FOUND_ERROR"), e);
                }
            }
        }
        return data;
    }

    @Override
    public InternetResource getResource(String path) throws ResourceNotFoundException {
        InternetResource internetResource = this.resources.get(path);
        if (null == internetResource) {
            throw new ResourceNotFoundException("Resource not registered : " + path);
        }
        return internetResource;
    }

    public void addResource(InternetResource resource) {
        this.resources.put(resource.getKey(), resource);
        ResourceRenderer renderer = resource.getRenderer(null);
        if (renderer == null) {
            this.setRenderer(resource, resource.getKey());
        }
    }

    @Override
    public void addResource(String key, InternetResource resource) {
        this.resources.put(key, resource);
        resource.setKey(key);
    }

    public String getFacesResourceURL(FacesContext context, String Url, boolean isGlobal) {
        return this.getWebXml(context).getFacesResourceURL(context, Url, isGlobal);
    }

    protected InternetResource createStaticResource(String path) throws ResourceNotFoundException, FacesException {
        ServletContext servletContext;
        InputStream in;
        FacesContext context = FacesContext.getCurrentInstance();
        if (null != context && context.getExternalContext().getContext() instanceof ServletContext && null != (in = (servletContext = (ServletContext)context.getExternalContext().getContext()).getResourceAsStream(path))) {
            StaticResource res = new StaticResource(path);
            this.setRenderer(res, path);
            res.setLastModified(new Date(this.getStartTime()));
            this.addResource(path, res);
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return res;
        }
        throw new ResourceNotFoundException(Messages.getMessage("STATIC_RESOURCE_NOT_FOUND_ERROR", path));
    }

    private void setRenderer(InternetResource res, String path) throws FacesException {
        int lastPoint = path.lastIndexOf(46);
        if (lastPoint > 0) {
            String ext = path.substring(lastPoint);
            ResourceRenderer resourceRenderer = this.getRendererByExtension(ext);
            if (null != resourceRenderer) {
                res.setRenderer(resourceRenderer);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("NO_RESOURCE_REGISTERED_ERROR_2", path, this.renderers.keySet()));
                }
                res.setRenderer(defaultRenderer);
            }
        }
    }

    protected ResourceRenderer getRendererByExtension(String ext) {
        return this.renderers.get(ext);
    }

    protected InternetResource createJarResource(Object base, String path) throws ResourceNotFoundException, FacesException {
        String key = this.buildKey(base, path);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (null != loader.getResource(key)) {
            JarResource res = new JarResource(key);
            this.setRenderer(res, path);
            res.setLastModified(new Date(this.getStartTime()));
            this.addResource(key, res);
            return res;
        }
        throw new ResourceNotFoundException(Messages.getMessage("NO_RESOURCE_EXISTS_ERROR", key));
    }

    protected InternetResource createDynamicResource(String path, Class<?> instatiate) throws ResourceNotFoundException {
        if (InternetResource.class.isAssignableFrom(instatiate)) {
            InternetResource resource;
            try {
                resource = (InternetResource)instatiate.newInstance();
                this.addResource(path, resource);
            }
            catch (Exception e) {
                String message = Messages.getMessage("INSTANTIATE_RESOURCE_ERROR", instatiate.toString());
                log.error(message, e);
                throw new ResourceNotFoundException(message, e);
            }
            return resource;
        }
        throw new FacesException(Messages.getMessage("INSTANTIATE_CLASS_ERROR"));
    }

    @Override
    public InternetResource createUserResource(boolean cacheable, boolean session, String mime) throws FacesException {
        InternetResource userResource;
        String path = this.getUserResourceKey(cacheable, session, mime);
        try {
            userResource = this.getResource(path);
        }
        catch (ResourceNotFoundException e) {
            userResource = new UserResource(cacheable, session, mime);
            this.addResource(path, userResource);
        }
        return userResource;
    }

    private String getUserResourceKey(boolean cacheable, boolean session, String mime) {
        StringBuffer pathBuffer = new StringBuffer(UserResource.class.getName());
        pathBuffer.append(cacheable ? "/c" : "/n");
        pathBuffer.append(session ? "/s" : "/n");
        if (null != mime) {
            pathBuffer.append('/').append(mime.hashCode());
        }
        String path = pathBuffer.toString();
        return path;
    }

    @Override
    public long getStartTime() {
        return this._startTime;
    }

    protected byte[] encrypt(byte[] src) {
        try {
            Deflater compressor = new Deflater(1);
            byte[] compressed = new byte[src.length + 100];
            compressor.setInput(src);
            compressor.finish();
            int totalOut = compressor.deflate(compressed);
            byte[] zipsrc = new byte[totalOut];
            System.arraycopy(compressed, 0, zipsrc, 0, totalOut);
            compressor.end();
            return this.codec.encode(zipsrc);
        }
        catch (Exception e) {
            throw new FacesException("Error encode resource data", e);
        }
    }

    protected byte[] decrypt(byte[] src) {
        try {
            byte[] zipsrc = this.codec.decode(src);
            Inflater decompressor = new Inflater();
            byte[] uncompressed = new byte[zipsrc.length * 5];
            decompressor.setInput(zipsrc);
            int totalOut = decompressor.inflate(uncompressed);
            byte[] out = new byte[totalOut];
            System.arraycopy(uncompressed, 0, out, 0, totalOut);
            decompressor.end();
            return out;
        }
        catch (Exception e) {
            throw new FacesException("Error decode resource data", e);
        }
    }

    @Override
    public ResourceRenderer getScriptRenderer() {
        return scriptRenderer;
    }

    @Override
    public ResourceRenderer getStyleRenderer() {
        return styleRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Thread thread = Thread.currentThread();
        ClassLoader initialTCCL = thread.getContextClassLoader();
        try {
            ClassLoader systemCL = ClassLoader.getSystemClassLoader();
            thread.setContextClassLoader(systemCL);
            ImageIO.setUseCache(false);
        }
        finally {
            thread.setContextClassLoader(initialTCCL);
        }
    }
}

