/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.UIResource;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.UserResourceRenderer2;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceRenderer;
import org.ajax4jsf.resource.URIInternetResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadResourceRendererBase
extends RendererBase
implements UserResourceRenderer2 {
    private static final String SCRIPT_COMPONENT_FAMILY = "org.ajax4jsf.LoadScript";
    private static final String STYLE_COMPONENT_FAMILY = "org.ajax4jsf.LoadStyle";

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return UIResource.class;
    }

    @Override
    public void encodeToHead(FacesContext context, UIComponent component) throws IOException {
        UIResource resource = (UIResource)component;
        Object src = resource.getSrc();
        if (null == src) {
            throw new FacesException("Source for resource is null for component " + resource.getClientId(context));
        }
        String family = resource.getFamily();
        ResourceRenderer renderer = null;
        InternetResource internetResource = null;
        Map<String, Object> attributes = Collections.emptyMap();
        if (SCRIPT_COMPONENT_FAMILY.equals(family)) {
            renderer = InternetResourceBuilder.getInstance().getScriptRenderer();
        } else if (STYLE_COMPONENT_FAMILY.equals(family)) {
            renderer = InternetResourceBuilder.getInstance().getStyleRenderer();
            String media = (String)resource.getAttributes().get("media");
            if (media != null && media.length() != 0) {
                attributes = new HashMap<String, Object>();
                attributes.put("media", media);
            }
        }
        if (src instanceof InternetResource) {
            internetResource = (InternetResource)src;
        } else if (resource.isRendered()) {
            String uri = context.getApplication().getViewHandler().getResourceURL(context, src.toString());
            uri = context.getExternalContext().encodeResourceURL(uri);
            internetResource = new URIInternetResource(uri);
        }
        if (internetResource != null) {
            renderer.encode(internetResource, context, null, attributes);
        }
    }
}

