/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import com.google.common.base.Strings;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.FacesBehaviorRenderer;
import org.ajax4jsf.component.AjaxClientBehavior;
import org.ajax4jsf.component.behavior.AjaxBehavior;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.event.BypassUpdatesAjaxBehaviorEvent;
import org.richfaces.renderkit.AjaxFunction;
import org.richfaces.renderkit.AjaxOptions;
import org.richfaces.renderkit.util.AjaxRendererUtils;
import org.richfaces.renderkit.util.RendererUtils;

@FacesBehaviorRenderer(rendererType="org.ajax4jsf.behavior.Ajax", renderKitId="HTML_BASIC")
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib")})
public class AjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    private final RendererUtils utils = RendererUtils.getInstance();

    @Override
    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        if (null == context || null == component || null == behavior) {
            throw new NullPointerException();
        }
        if (!(behavior instanceof AjaxBehavior)) {
            throw new IllegalArgumentException("org.ajax4jsf.component.behavior.AjaxBehavior required: " + behavior);
        }
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled()) {
            return;
        }
        component.queueEvent(this.createEvent(component, ajaxBehavior));
        if (this.isBypassUpdates(component, ajaxBehavior)) {
            component.queueEvent(new BypassUpdatesAjaxBehaviorEvent(component, ajaxBehavior));
        }
    }

    private AjaxBehaviorEvent createEvent(UIComponent component, AjaxBehavior ajaxBehavior) {
        AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, ajaxBehavior);
        PhaseId phaseId = this.isImmediate(component, ajaxBehavior) ? PhaseId.APPLY_REQUEST_VALUES : (this.isBypassUpdates(component, ajaxBehavior) ? PhaseId.PROCESS_VALIDATIONS : PhaseId.INVOKE_APPLICATION);
        event.setPhaseId(phaseId);
        return event;
    }

    private boolean isImmediate(UIComponent component, AjaxBehavior ajaxBehavior) {
        boolean immediate = ajaxBehavior.isImmediate();
        if (!immediate) {
            if (component instanceof EditableValueHolder) {
                immediate = ((EditableValueHolder)((Object)component)).isImmediate();
            } else if (component instanceof ActionSource) {
                immediate = ((ActionSource)((Object)component)).isImmediate();
            }
        }
        return immediate;
    }

    private boolean isBypassUpdates(UIComponent component, AjaxBehavior ajaxBehavior) {
        boolean bypassUpdates = ajaxBehavior.isBypassUpdates();
        if (!bypassUpdates) {
            bypassUpdates = this.utils.isBooleanAttribute(component, "bypassUpdates");
        }
        return bypassUpdates;
    }

    @Override
    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        String script = null;
        if (behavior instanceof AjaxBehavior && !((AjaxBehavior)behavior).isDisabled()) {
            script = this.buildAjaxCommand(behaviorContext, (AjaxBehavior)behavior);
        }
        return script;
    }

    public String buildAjaxCommand(ClientBehaviorContext bContext, AjaxBehavior behavior) {
        return this.buildAjaxFunction(bContext, behavior).toString();
    }

    public AjaxFunction buildAjaxFunction(ClientBehaviorContext behaviorContext, AjaxClientBehavior behavior) {
        Object source;
        AjaxOptions options = this.buildAjaxOptions(behaviorContext, behavior);
        if (behaviorContext.getSourceId() != null) {
            source = behaviorContext.getSourceId();
        } else {
            source = JSReference.THIS;
            FacesContext facesContext = behaviorContext.getFacesContext();
            UIComponent component = behaviorContext.getComponent();
            options.setAjaxComponent(component.getClientId(facesContext));
            options.set("sourceId", source);
        }
        if (behavior.isResetValues()) {
            options.setParameter("javax.faces.partial.resetValues", true);
        }
        return new AjaxFunction(source, options);
    }

    private AjaxOptions buildAjaxOptions(ClientBehaviorContext behaviorContext, AjaxClientBehavior ajaxBehavior) {
        FacesContext facesContext = behaviorContext.getFacesContext();
        UIComponent component = behaviorContext.getComponent();
        AjaxOptions ajaxOptions = new AjaxOptions();
        Map<String, Object> parametersMap = RendererUtils.getInstance().createParametersMap(facesContext, component);
        ajaxOptions.addParameters(parametersMap);
        String ajaxStatusName = ajaxBehavior.getStatus();
        if (Strings.isNullOrEmpty(ajaxStatusName)) {
            ajaxStatusName = AjaxRendererUtils.getAjaxStatus(component);
        }
        if (!Strings.isNullOrEmpty(ajaxStatusName)) {
            ajaxOptions.set("status", ajaxStatusName);
        }
        this.appenAjaxBehaviorOptions(behaviorContext, ajaxBehavior, ajaxOptions);
        return ajaxOptions;
    }

    private void appenAjaxBehaviorOptions(ClientBehaviorContext behaviorContext, AjaxClientBehavior behavior, AjaxOptions ajaxOptions) {
        ajaxOptions.setParameter("javax.faces.behavior.event", behaviorContext.getEventName());
        ajaxOptions.setBeforesubmitHandler(behavior.getOnbeforesubmit());
        for (BehaviorOptionsData optionsData : BehaviorOptionsData.values()) {
            String optionValue = optionsData.getAttributeValue(behavior);
            if (Strings.isNullOrEmpty(optionValue)) continue;
            ajaxOptions.set(optionsData.toString(), optionValue);
        }
    }

    private static enum BehaviorOptionsData {
        begin{

            @Override
            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getOnbegin();
            }
        }
        ,
        error{

            @Override
            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getOnerror();
            }
        }
        ,
        queueId{

            @Override
            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getQueueId();
            }
        };


        public abstract String getAttributeValue(AjaxClientBehavior var1);
    }
}

