/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.richfaces.ui.component.DummyHighLight;
import org.richfaces.ui.component.Highlight;
import org.richfaces.ui.component.HighlightImpl;
import org.richfaces.ui.component.UIInsert;

public abstract class AbstractInsertRenderer
extends HeaderResourcesRendererBase {
    private static final Object ERROR_MESSAGE_CLASS = "dr-insert-error";

    public void renderContent(FacesContext context, UIInsert component) throws IOException {
        boolean isContentAvailable;
        String src = component.getSrc();
        boolean isSrcAvailable = src != null;
        String content = component.getContent();
        boolean bl = isContentAvailable = content != null;
        if (isSrcAvailable && isContentAvailable) {
            throw new FacesException("Only one attribute should be set for the <rich:insert> component: either \"content\" or \"src\".");
        }
        if (isSrcAvailable || isContentAvailable) {
            ExternalContext externalContext = context.getExternalContext();
            InputStream inputStream = null;
            if (isSrcAvailable) {
                inputStream = externalContext.getResourceAsStream(src);
            } else if (isContentAvailable) {
                inputStream = new ByteArrayInputStream(content.getBytes());
            }
            if (null != inputStream) {
                this.renderStream(context, component, inputStream);
            } else {
                String errorContent = component.getErrorContent();
                if (null != errorContent && null != (inputStream = externalContext.getResourceAsStream(errorContent))) {
                    this.renderStream(context, component, inputStream);
                } else {
                    this.renderErrorMessage(context, component, "UI_INSERT_RESOURCE_NOT_FOUND");
                }
            }
        } else {
            throw new FacesException("Attribute 'scr' for a component <rich:insert> " + component.getClientId(context) + " must be set");
        }
    }

    private void renderErrorMessage(FacesContext context, UIInsert component, String message) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", component);
        writer.writeAttribute("class", ERROR_MESSAGE_CLASS, null);
        writer.write(Messages.getMessage(message, new Object[]{component.getClientId(context), component.getSrc()}));
        writer.endElement("span");
    }

    private void renderStream(FacesContext context, UIInsert component, InputStream inputStream) throws UnsupportedEncodingException, FacesException, IOException {
        Highlight highlighter;
        ResponseWriter writer = context.getResponseWriter();
        String encoding = component.getEncoding();
        if (null == component.getHighlight()) {
            InputStreamReader in = null != encoding ? new InputStreamReader(inputStream, encoding) : new InputStreamReader(inputStream);
            char[] temp = new char[1024];
            try {
                int bytes;
                while ((bytes = in.read(temp)) > 0) {
                    writer.write(temp, 0, bytes);
                }
            }
            catch (IOException e) {
                throw new FacesException(e);
            }
            finally {
                in.close();
            }
        }
        try {
            highlighter = new HighlightImpl(component.getHighlight());
        }
        catch (NoClassDefFoundError e) {
            this.renderErrorMessage(context, component, "HIGHLIGHT_LIBRARY_NOT_FOUND");
            highlighter = new DummyHighLight();
        }
        try {
            highlighter.highlight(component.getSrc(), inputStream, writer, encoding);
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        finally {
            inputStream.close();
        }
    }
}

