/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.event;

import java.util.Iterator;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.ajax4jsf.application.AjaxViewHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InitPhaseListener
implements PhaseListener {
    private volatile boolean removed = false;
    private volatile boolean initialized = false;
    private static final Log log = LogFactory.getLog(InitPhaseListener.class);

    public synchronized void afterPhase(PhaseEvent event) {
        if (!this.removed) {
            if (log.isDebugEnabled()) {
                log.debug("Remove init phase listener from factories");
            }
            LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            Iterator<String> iter = factory.getLifecycleIds();
            while (iter.hasNext()) {
                Lifecycle lifecycle = factory.getLifecycle(iter.next());
                lifecycle.removePhaseListener(this);
            }
            this.removed = true;
        }
    }

    public synchronized void beforePhase(PhaseEvent event) {
        if (!this.initialized) {
            FacesContext facesContext;
            Application application;
            ViewHandler viewHandler;
            if (log.isDebugEnabled()) {
                log.debug("Perform additional framework initialization on first request");
            }
            if (!((viewHandler = (application = (facesContext = event.getFacesContext()).getApplication()).getViewHandler()) instanceof AjaxViewHandler)) {
                if (log.isDebugEnabled()) {
                    log.debug("Set AjaxViewHandler on top of chain");
                }
                AjaxViewHandler ajaxViewHandler = new AjaxViewHandler(viewHandler);
                ajaxViewHandler.fillChain(facesContext);
                application.setViewHandler(ajaxViewHandler);
            } else {
                ((AjaxViewHandler)viewHandler).fillChain(facesContext);
            }
            this.initialized = true;
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

