/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.ajax4jsf.Messages;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.ViewIdHolder;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxContextImpl
extends AjaxContext {
    public static final String SERVLET_ERROR_EXCEPTION_ATTRIBUTE = "javax.servlet.error.exception";
    private static final Log log = LogFactory.getLog(AjaxContext.class);
    Set<String> ajaxAreasToRender = new LinkedHashSet<String>();
    Set<String> ajaxAreasToProcess = null;
    Set<String> ajaxRenderedAreas = new LinkedHashSet<String>();
    boolean ajaxRequest = false;
    boolean selfRender = false;
    Integer viewSequence = new Integer(1);
    String submittedRegionClientId = null;
    String ajaxSingleClientId = null;
    ViewIdHolder viewIdHolder = null;
    Map<String, Object> responseDataMap = new HashMap<String, Object>();
    Map<String, Object> commonAjaxParameters = new HashMap<String, Object>();
    Object oncomplete = null;

    @Override
    public void release() {
        this.ajaxAreasToRender = new LinkedHashSet<String>();
        this.ajaxAreasToProcess = null;
        this.ajaxRenderedAreas = new LinkedHashSet<String>();
        this.ajaxRequest = false;
        this.selfRender = false;
        this.viewSequence = new Integer(1);
        this.submittedRegionClientId = null;
        this.viewIdHolder = null;
        this.responseDataMap = new HashMap<String, Object>();
        this.commonAjaxParameters = new HashMap<String, Object>();
    }

    @Override
    public void decode(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        if (null == externalContext.getRequestMap().get(SERVLET_ERROR_EXCEPTION_ATTRIBUTE)) {
            Map<String, String> requestParameterMap = externalContext.getRequestParameterMap();
            String ajaxRegionId = requestParameterMap.get("AJAXREQUEST");
            this.setSubmittedRegionClientId(ajaxRegionId);
            this.setAjaxRequest(null != ajaxRegionId);
            this.setAjaxSingleClientId(requestParameterMap.get("ajaxSingle"));
        } else {
            this.setAjaxRequest(false);
            this.setSubmittedRegionClientId(null);
            this.setAjaxSingleClientId(null);
        }
    }

    @Override
    public void renderAjax(FacesContext context) throws FacesException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("RENDER_AJAX_REQUEST", this.getSubmittedRegionClientId()));
        }
        try {
            String encoding;
            this.setSelfRender(true);
            this.setAjaxRequest(true);
            ExternalContext extContext = context.getExternalContext();
            RenderKit renderKit = context.getRenderKit();
            if (extContext.getRequest() instanceof ServletRequest) {
                ServletRequest request = (ServletRequest)extContext.getRequest();
                ServletResponse response = (ServletResponse)extContext.getResponse();
                String contentType = "text/xml";
                encoding = request.getCharacterEncoding();
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                response.setContentType(contentType + ";charset=" + encoding);
            } else {
                encoding = "UTF-8";
            }
            PrintWriter servletWriter = this.getWriter(extContext);
            ResponseWriter writer = renderKit.createResponseWriter(servletWriter, null, encoding);
            context.setResponseWriter(writer);
            writer.startDocument();
            this.encodeAjaxBegin(context);
            context.getViewRoot().encodeAll(context);
            this.saveViewState(context);
            this.encodeAjaxEnd(context);
            writer.endDocument();
            writer.flush();
            writer.close();
            servletWriter.close();
        }
        catch (IOException e) {
            throw new FacesException(Messages.getMessage("RENDERING_AJAX_REGION_ERROR", this.getSubmittedRegionClientId()), e);
        }
        finally {
            context.responseComplete();
        }
    }

    @Override
    public void encodeAjaxBegin(FacesContext context) throws IOException {
        UIViewRoot viewRoot = context.getViewRoot();
        ResponseWriter out = context.getResponseWriter();
        out.startElement("html", viewRoot);
        Locale locale = viewRoot.getLocale();
        out.writeAttribute("lang", locale.toString(), "lang");
        out.startElement("body", viewRoot);
    }

    @Override
    public void encodeAjaxEnd(FacesContext context) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.endElement("body");
        out.endElement("html");
    }

    @Override
    public void saveViewState(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StateManager stateManager = context.getApplication().getStateManager();
        Object serializedView = stateManager.saveView(context);
        if (null != serializedView && null != writer) {
            StringWriter bufWriter = new StringWriter();
            ResponseWriter tempWriter = writer.cloneWithWriter(bufWriter);
            context.setResponseWriter(tempWriter);
            stateManager.writeState(context, serializedView);
            tempWriter.flush();
            if (bufWriter.getBuffer().length() > 0) {
                context.getExternalContext().getRequestMap().put("org.ajax4jsf.view.serializedstate", bufWriter.toString());
            }
            context.setResponseWriter(writer);
        }
    }

    protected RenderKit getRenderKit(FacesContext context) {
        RenderKit renderKit = context.getRenderKit();
        if (null == renderKit) {
            String renderKitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
            RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
            renderKit = factory.getRenderKit(context, renderKitId);
        }
        return renderKit;
    }

    @Override
    public boolean isAjaxRequest() {
        return this.ajaxRequest;
    }

    @Override
    public void setAjaxRequest(boolean ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    @Override
    public Set<String> getAjaxAreasToRender() {
        return this.ajaxAreasToRender;
    }

    @Override
    public Set<String> getAjaxAreasToProcess() {
        return this.ajaxAreasToProcess;
    }

    @Override
    public void setAjaxAreasToProcess(Set<String> ajaxAreasToProcess) {
        this.ajaxAreasToProcess = ajaxAreasToProcess;
    }

    @Override
    public void addRegionsFromComponent(UIComponent component) {
        Set<String> ajaxRegions = AjaxRendererUtils.getAjaxAreas(component);
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("INVOKE_AJAX_REGION_LISTENER", component.getId()));
        }
        if (ajaxRegions != null) {
            Iterator<String> iter = ajaxRegions.iterator();
            while (iter.hasNext()) {
                String id = iter.next().toString();
                this.ajaxAreasToRender.add(this.convertId(component, id));
            }
        }
        if (Boolean.TRUE.equals(component.getAttributes().get("limitToList"))) {
            this.setLimitToList(true);
        }
    }

    @Override
    public void addAreasToProcessFromComponent(FacesContext context, UIComponent component) {
        RendererUtils rendererUtils = RendererUtils.getInstance();
        Set<String> areasToProcess = AjaxRendererUtils.getAjaxAreasToProcess(component);
        if (areasToProcess != null) {
            HashSet<String> convertedAreaIds = new HashSet<String>();
            for (String areaId : areasToProcess) {
                UIComponent areaComponent = rendererUtils.findComponentFor(component, areaId);
                if (areaComponent != null) {
                    convertedAreaIds.add(areaComponent.getClientId(context));
                    continue;
                }
                convertedAreaIds.add(areaId);
            }
            if (this.ajaxAreasToProcess == null) {
                this.ajaxAreasToProcess = convertedAreaIds;
            } else {
                this.ajaxAreasToProcess.addAll(convertedAreaIds);
            }
        }
    }

    @Override
    public void addComponentToAjaxRender(UIComponent component) {
        this.ajaxAreasToRender.add(AjaxRendererUtils.getAbsoluteId(component));
    }

    @Override
    public void addComponentToAjaxRender(UIComponent base, String id) {
        this.ajaxAreasToRender.add(this.convertId(base, id));
    }

    private String convertId(UIComponent component, String id) {
        if (id.charAt(0) == ':') {
            return id;
        }
        if (null == component) {
            throw new NullPointerException("Base component for search re-rendered compnnent is null");
        }
        UIComponent target = RendererUtils.getInstance().findComponentFor(component, id);
        if (null != target) {
            return AjaxRendererUtils.getAbsoluteId(target);
        }
        log.warn("Target component for id " + id + " not found");
        return id;
    }

    @Override
    public Set<String> getAjaxRenderedAreas() {
        return this.ajaxRenderedAreas;
    }

    @Override
    public void addRenderedArea(String id) {
        this.ajaxRenderedAreas.add(id);
    }

    @Override
    public boolean removeRenderedArea(String id) {
        return this.ajaxRenderedAreas.remove(id);
    }

    @Override
    public String getSubmittedRegionClientId() {
        return this.submittedRegionClientId;
    }

    @Override
    public void setSubmittedRegionClientId(String submittedClientId) {
        this.submittedRegionClientId = submittedClientId;
    }

    @Override
    public String getAjaxSingleClientId() {
        return this.ajaxSingleClientId;
    }

    @Override
    public void setAjaxSingleClientId(String ajaxSingleClientId) {
        this.ajaxSingleClientId = ajaxSingleClientId;
    }

    @Override
    public boolean isSelfRender() {
        return this.selfRender;
    }

    @Override
    public void setSelfRender(boolean selfRender) {
        this.selfRender = selfRender;
    }

    @Override
    public ViewIdHolder getViewIdHolder() {
        return this.viewIdHolder;
    }

    @Override
    public void setViewIdHolder(ViewIdHolder viewIdHolder) {
        this.viewIdHolder = viewIdHolder;
    }

    @Override
    public Object getResponseData() {
        return this.responseDataMap.get("_ajax:data");
    }

    @Override
    public void setResponseData(Object responseData) {
        this.responseDataMap.put("_ajax:data", responseData);
    }

    @Override
    public Map<String, Object> getResponseDataMap() {
        return this.responseDataMap;
    }

    protected PrintWriter getWriter(ExternalContext extContext) throws FacesException {
        PrintWriter writer = null;
        Object response = extContext.getResponse();
        try {
            Method gW = response.getClass().getMethod("getWriter", new Class[0]);
            writer = (PrintWriter)gW.invoke(response, new Object[0]);
        }
        catch (Exception e) {
            throw new FacesException(e);
        }
        return writer;
    }

    @Override
    public String getAjaxActionURL(FacesContext context) {
        if (null == context) {
            throw new NullPointerException("Faces context for build AJAX Action URL is null");
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (null == viewRoot) {
            throw new NullPointerException("Faces view tree for build AJAX Action URL is null");
        }
        String viewId = viewRoot.getViewId();
        if (null == viewId) {
            throw new NullPointerException("View id for build AJAX Action URL is null");
        }
        if (!viewId.startsWith("/")) {
            throw new IllegalArgumentException("Illegal view Id for build AJAX Action URL: " + viewId);
        }
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        String actionURL = viewHandler.getActionURL(context, viewId);
        if (null != context.getExternalContext().getApplicationMap().get("org.jboss.portletbridge.application.PortletStateHolder")) {
            actionURL = actionURL + (actionURL.lastIndexOf(63) > 0 ? "&" : "?") + "javax.portlet.faces.DirectLink=true";
        }
        return context.getExternalContext().encodeActionURL(actionURL);
    }

    @Override
    public Map<String, Object> getCommonAjaxParameters() {
        return this.commonAjaxParameters;
    }

    @Override
    public Object getOncomplete() {
        return this.oncomplete;
    }

    @Override
    public void setOncomplete(Object oncomplete) {
        this.oncomplete = oncomplete;
    }
}

