/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.component;

import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.AjaxActionComponent;
import org.ajax4jsf.component.AjaxSupport;
import org.ajax4jsf.component.EventValueExpression;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UIAjaxSupport
extends AjaxActionComponent
implements AjaxSupport {
    public static final String COMPONENT_TYPE = "org.ajax4jsf.Support";
    public static final String COMPONENT_FAMILY = "org.ajax4jsf.AjaxSupport";
    public static final String DEFAULT_RENDERER_TYPE = "org.ajax4jsf.components.AjaxSupportRenderer";
    public static final String AJAX_SUPPORT_SET = "com.exadel.components.ajax.support.";
    private static final Log log = LogFactory.getLog(UIAjaxSupport.class);

    public void setValueExpression(String name, ValueExpression binding) {
        if ("var".equals(name)) {
            throw new FacesException(Messages.getMessage("VAR_MUST_BE_LITERAL", this.getClientId(this.getFacesContext())));
        }
        if ("event".equals(name)) {
            throw new FacesException(Messages.getMessage("EVENT_MUST_BE_LITERAL", this.getClientId(this.getFacesContext())));
        }
        super.setValueExpression(name, binding);
    }

    private ValueExpression getEventValueBinding() {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("CREATE_JAVASCRIPT_EVENT", this.getId()));
        }
        return new EventValueExpression(this);
    }

    public String getEventString() {
        StringBuffer buildOnEvent = new StringBuffer();
        String onsubmit = this.getOnsubmit();
        if (null != onsubmit) {
            buildOnEvent.append(onsubmit).append(";");
        }
        buildOnEvent.append(AjaxRendererUtils.buildOnEvent(this, this.getFacesContext(), this.getEvent(), true));
        String script = buildOnEvent.toString();
        return script;
    }

    public void decode(FacesContext context) {
        this.setId(this.getId());
        super.decode(context);
    }

    public void setParent(UIComponent parent) {
        super.setParent(parent);
        if (null != parent && parent.getFamily() != null) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("CALLED_SET_PARENT", parent.getClass().getName()));
            }
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("DETECT_NEW_COMPONENT"));
            }
            this.setParentProperties(parent);
        }
    }

    public void setParentProperties(UIComponent parent) {
        if (null != this.getEvent()) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("SET_VALUE_BINDING_FOR_EVENT", this.getEvent()));
            }
            ValueExpression valueBinding = this.getEventValueBinding();
            parent.setValueExpression(this.getEvent(), valueBinding);
        }
    }

    protected UIComponent getSingleComponent() {
        return this.getParent();
    }
}

