/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.ajax4jsf.application.DebugOutputMaker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugLifecycle
extends Lifecycle
implements PhaseListener {
    private static final long serialVersionUID = -3247965217553145312L;
    private Lifecycle _default;
    private static Log _log = LogFactory.getLog(DebugLifecycle.class);
    public static final String DEBUG_LYFECYCLE_ID = "DEBUG";
    public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";
    public static final String PHASE_ID_PARAM = "org.ajax4jsf.CURRENT_PHASE";
    private static final DebugOutputMaker debugOutput = new DebugOutputMaker();

    public DebugLifecycle(Lifecycle default1) {
        this._default = default1;
    }

    public DebugLifecycle(LifecycleFactory defaultFactory) {
        this._default = defaultFactory.getLifecycle("DEFAULT");
        this._default.addPhaseListener(this);
    }

    public void addPhaseListener(PhaseListener arg0) {
        this._default.addPhaseListener(arg0);
    }

    public void execute(FacesContext context) throws FacesException {
        try {
            this._default.execute(context);
        }
        catch (Throwable e) {
            debugOutput.writeErrorMessage(context, e, "execute");
            context.responseComplete();
        }
    }

    public PhaseListener[] getPhaseListeners() {
        return this._default.getPhaseListeners();
    }

    public void removePhaseListener(PhaseListener arg0) {
        this._default.removePhaseListener(arg0);
    }

    public void render(FacesContext context) throws FacesException {
        try {
            this._default.render(context);
        }
        catch (Throwable e) {
            debugOutput.writeErrorMessage(context, e, "render");
            context.responseComplete();
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (_log.isDebugEnabled()) {
            _log.debug("End phase " + event.getPhaseId().toString());
        }
    }

    public void beforePhase(PhaseEvent event) {
        if (_log.isDebugEnabled()) {
            _log.debug("Start phase " + event.getPhaseId().toString());
        }
        event.getFacesContext().getExternalContext().getRequestMap().put(PHASE_ID_PARAM, event.getPhaseId());
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

