from rex.exploit.cgc import CGCType1Exploit

class CGCType1ShellcodeExploit(CGCType1Exploit):
    '''
    A CGC type1 exploit object, which sets a register via shellcode.
    '''

    def __init__(self, crash, register, reg_bitmask, ip_bitmask, shc_mem, value_var, ip_var):
        '''
        :param crash: a crash object which has been modified to exploit a vulnerability
        :param register: the register set by the exploit
        :param reg_bitmask: bitmask for register value to set
        :param ip_bitmask: bitmask for ip value to set
        :param shc_mem: memory contained our shellcode
        :param value_var: variable representing the value to set the register to
        :param ip_var: ip representing the value to set ip to
        '''
        super(CGCType1ShellcodeExploit, self).__init__(crash, register, bypasses_nx=False, bypasses_aslr=False,
                                                       reg_bitmask=reg_bitmask, ip_bitmask=ip_bitmask)

        self.method_name = 'shellcode'

        self._mem = shc_mem
        self._arg_vars = [value_var, ip_var]

        self._generate_formula()

    def __str__(self):
        return "<%s> shellcode type1" % self.register
