from rex.exploit.cgc import CGCType1Exploit

class CGCType1RopExploit(CGCType1Exploit):
    '''
    A CGC type1 exploit object, which sets a register via Rop.
    '''

    def __init__(self, crash, register, reg_bitmask, ip_bitmask, ch_mem, value_var, ip_var):
        '''
        :param crash: a crash object which has been modified to exploit a vulnerability
        :param register: the register set by the exploit
        :param reg_bitmask: bitmask to apply to the register value
        :param ip_bitmask: bitmask to apply to the ip value
        :param ch_mem: memory representing the chain in memory
        :param value_var: claripy variable representing the value to set
        :param ip_var: claripy variable representing the ip to set
        '''
        super(CGCType1RopExploit, self).__init__(crash, register,
                bypasses_nx=True, bypasses_aslr=True,
                reg_bitmask=reg_bitmask, ip_bitmask=ip_bitmask)

        self.method_name = 'rop'

        self._mem = ch_mem
        self._arg_vars = [value_var, ip_var]

        self._generate_formula()

    def __str__(self):
        return "<%s> rop type1" % self.register
