/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.util.dwt;

import com.openstego.desktop.util.dwt.Filter;
import com.openstego.desktop.util.dwt.FilterGH;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FilterXMLReader {
    private FilterXMLReader() {
    }

    public static Map<Integer, FilterGH> parse(String fileURI) {
        HashMap<Integer, FilterGH> filterGHMap = new HashMap<Integer, FilterGH>();
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = db.parse(FilterXMLReader.class.getResourceAsStream(fileURI));
            NodeList nl = dom.getDocumentElement().getElementsByTagName("filterGH");
            if (nl != null && nl.getLength() > 0) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    FilterGH filterGH = FilterXMLReader.getFilterGH(el);
                    filterGHMap.put(filterGH.getId(), filterGH);
                }
            }
            return filterGHMap;
        }
        catch (IOException | ParserConfigurationException | SAXException pcEx) {
            pcEx.printStackTrace();
            throw new IllegalArgumentException("Invalid Filter XML file");
        }
    }

    private static FilterGH getFilterGH(Element el) {
        FilterGH filterGH = new FilterGH();
        filterGH.setId(Integer.parseInt(el.getAttribute("id")));
        filterGH.setName(el.getAttribute("name"));
        filterGH.setType(el.getAttribute("type"));
        NodeList nl = el.getElementsByTagName("filter");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element innerEl = (Element)nl.item(i);
                Filter filter = FilterXMLReader.getFilter(innerEl);
                filter.setHiPass((i & 1) != 1);
                if (i == 0) {
                    filterGH.setG(filter);
                    continue;
                }
                if (i == 1) {
                    filterGH.setH(filter);
                    continue;
                }
                if (i == 2) {
                    filterGH.setGi(filter);
                    continue;
                }
                if (i != 3) continue;
                filterGH.setHi(filter);
            }
        }
        return filterGH;
    }

    private static Filter getFilter(Element el) {
        Filter filter = new Filter();
        double[] data = null;
        filter.setType(el.getAttribute("type"));
        filter.setStart(Integer.parseInt(el.getAttribute("start")));
        filter.setEnd(Integer.parseInt(el.getAttribute("end")));
        NodeList nl = el.getElementsByTagName("data");
        if (nl != null && nl.getLength() > 0) {
            data = new double[nl.getLength()];
            for (int i = 0; i < nl.getLength(); ++i) {
                Element innerEl = (Element)nl.item(i);
                data[i] = Double.parseDouble(innerEl.getFirstChild().getNodeValue());
            }
        }
        filter.setData(data);
        return filter;
    }
}

