/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.util;

import com.openstego.desktop.OpenStegoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class UserPreferences {
    private static final String PREF_FILENAME = "openstego.cfg";
    private static final String DEFAULT_PREF_FILENAME = "openstego.default.cfg";
    private static Properties prefs = null;

    protected UserPreferences() {
    }

    public static void init() throws OpenStegoException {
        if (prefs != null) {
            return;
        }
        prefs = new Properties();
        try {
            Path prefFile;
            Path configPath;
            String userHome = System.getProperty("user.home");
            String configHome = System.getenv("XDG_CONFIG_HOME");
            if (configHome == null || configHome.trim().length() == 0) {
                configHome = userHome + File.separator + ".config";
            }
            if (Files.notExists(configPath = Paths.get(configHome, "openstego"), new LinkOption[0])) {
                Files.createDirectories(configPath, new FileAttribute[0]);
            }
            if (Files.notExists(prefFile = configPath.resolve(PREF_FILENAME), new LinkOption[0])) {
                Path oldPrefFile = Paths.get(userHome, "openstego.ini");
                if (Files.exists(oldPrefFile, new LinkOption[0])) {
                    Files.copy(oldPrefFile, prefFile, new CopyOption[0]);
                    Files.delete(oldPrefFile);
                } else {
                    try (InputStream tmplIS = UserPreferences.class.getResourceAsStream("/openstego.default.cfg");){
                        assert (tmplIS != null);
                        Files.copy(tmplIS, prefFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
            }
            try (InputStream prefFileIS = Files.newInputStream(prefFile, new OpenOption[0]);){
                prefs.load(prefFileIS);
            }
        }
        catch (IOException e) {
            throw new OpenStegoException(e);
        }
    }

    public static String getString(String key) {
        String val = prefs.getProperty(key);
        if (val == null) {
            return null;
        }
        return val.trim();
    }

    public static Integer getInteger(String key) throws OpenStegoException {
        String val = UserPreferences.getString(key);
        if (val == null) {
            return null;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw new OpenStegoException(null, "OpenStego", 17, key);
        }
    }

    public static Float getFloat(String key) throws OpenStegoException {
        String val = UserPreferences.getString(key);
        if (val == null) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(val));
        }
        catch (NumberFormatException e) {
            throw new OpenStegoException(null, "OpenStego", 18, key);
        }
    }

    public static Boolean getBoolean(String key) throws OpenStegoException {
        String val = UserPreferences.getString(key);
        if (val == null) {
            return null;
        }
        if ("t".equals(val = val.toLowerCase()) || "true".equals(val) || "y".equals(val) || "yes".equals(val) || "1".equals(val)) {
            return true;
        }
        if ("f".equals(val) || "false".equals(val) || "n".equals(val) || "no".equals(val) || "0".equals(val)) {
            return false;
        }
        throw new OpenStegoException(null, "OpenStego", 19, key);
    }
}

