/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.lsb;

import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.lsb.LSBConfig;
import com.openstego.desktop.plugin.lsb.LSBDataHeader;
import com.openstego.desktop.plugin.lsb.LSBErrors;
import com.openstego.desktop.plugin.lsb.LSBInputStream;
import com.openstego.desktop.plugin.lsb.LSBOutputStream;
import com.openstego.desktop.plugin.template.image.DHImagePluginTemplate;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.ImageUtil;
import com.openstego.desktop.util.LabelUtil;
import com.openstego.desktop.util.cmd.CmdLineOptions;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;

public class LSBPlugin
extends DHImagePluginTemplate<LSBConfig> {
    private static final LabelUtil labelUtil = LabelUtil.getInstance("LSB");
    public static final String NAMESPACE = "LSB";

    public LSBPlugin() {
        LabelUtil.addNamespace(NAMESPACE, "i18n.LSBPluginLabels");
        LSBErrors.init();
    }

    @Override
    public String getName() {
        return NAMESPACE;
    }

    @Override
    public String getDescription() {
        return labelUtil.getString("plugin.description");
    }

    @Override
    public byte[] embedData(byte[] msg, String msgFileName, byte[] cover, String coverFileName, String stegoFileName) throws OpenStegoException {
        try {
            ImageHolder image;
            if (cover == null) {
                int numOfPixels = (int)((double)(LSBDataHeader.getMaxHeaderSize() * 8) / 3.0);
                image = ImageUtil.generateRandomImage(numOfPixels += (int)((double)(msg.length * 8) / (3.0 * (double)((LSBConfig)this.config).getMaxBitsUsedPerChannel())));
            } else {
                image = ImageUtil.byteArrayToImage(cover, coverFileName);
            }
            try (LSBOutputStream lsbOS = new LSBOutputStream(image, msg.length, msgFileName, this.config);){
                lsbOS.write(msg);
                lsbOS.flush();
                image = lsbOS.getImage();
            }
            return ImageUtil.imageToByteArray(image, stegoFileName, this);
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
    }

    @Override
    public String extractMsgFileName(byte[] stegoData, String stegoFileName) throws OpenStegoException {
        String string;
        ImageHolder imgHolder = ImageUtil.byteArrayToImage(stegoData, stegoFileName);
        LSBInputStream lsbIS = new LSBInputStream(imgHolder, this.config);
        try {
            string = lsbIS.getDataHeader().getFileName();
        }
        catch (Throwable throwable) {
            try {
                try {
                    lsbIS.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioEx) {
                throw new OpenStegoException(ioEx);
            }
        }
        lsbIS.close();
        return string;
    }

    @Override
    public byte[] extractData(byte[] stegoData, String stegoFileName, byte[] origSigData) throws OpenStegoException {
        byte[] byArray;
        ImageHolder imgHolder = ImageUtil.byteArrayToImage(stegoData, stegoFileName);
        LSBInputStream lsbIS = new LSBInputStream(imgHolder, this.config);
        try {
            LSBDataHeader header = lsbIS.getDataHeader();
            byte[] data = new byte[header.getDataLength()];
            int bytesRead = lsbIS.read(data, 0, data.length);
            if (bytesRead != data.length) {
                throw new OpenStegoException(null, NAMESPACE, 1);
            }
            byArray = data;
        }
        catch (Throwable throwable) {
            try {
                try {
                    lsbIS.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new OpenStegoException(ex);
            }
        }
        lsbIS.close();
        return byArray;
    }

    @Override
    public List<String> getWritableFileExtensions() throws OpenStegoException {
        if (writeFormats != null) {
            return writeFormats;
        }
        super.getWritableFileExtensions();
        block2: for (int i = writeFormats.size() - 1; i >= 0; --i) {
            String format = (String)writeFormats.get(i);
            Iterator<ImageWriter> iter = ImageIO.getImageWritersBySuffix(format);
            while (iter.hasNext()) {
                ImageWriteParam writeParam;
                block5: {
                    writeParam = iter.next().getDefaultWriteParam();
                    try {
                        writeParam.setCompressionMode(2);
                        String[] compTypes = writeParam.getCompressionTypes();
                        if (compTypes.length <= 0) break block5;
                        writeParam.setCompressionType(compTypes[0]);
                    }
                    catch (UnsupportedOperationException uoEx) {
                        continue block2;
                    }
                }
                if (writeParam.isCompressionLossless()) continue block2;
                writeFormats.remove(i);
            }
        }
        writeFormats.remove("gif");
        writeFormats.remove("wbmp");
        writeFormats.remove("tif");
        writeFormats.remove("tiff");
        return writeFormats;
    }

    @Override
    public void populateStdCmdLineOptions(CmdLineOptions options) {
        options.add("-b", "--maxBitsUsedPerChannel", 1, true);
    }

    @Override
    protected LSBConfig createConfig() {
        return new LSBConfig();
    }

    @Override
    protected LSBConfig createConfig(CmdLineOptions options) throws OpenStegoException {
        LSBConfig config = new LSBConfig();
        config.initialize(options);
        return config;
    }

    @Override
    public String getUsage() {
        LSBConfig defaultConfig = new LSBConfig();
        return labelUtil.getString("plugin.usage", defaultConfig.getMaxBitsUsedPerChannel());
    }
}

