/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop;

import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.ui.OpenStegoFrame;
import com.openstego.desktop.ui.PluginEmbedOptionsUI;
import com.openstego.desktop.util.LabelUtil;
import com.openstego.desktop.util.cmd.CmdLineOptions;
import java.util.List;

public abstract class OpenStegoPlugin<C extends OpenStegoConfig> {
    protected C config = null;

    public abstract String getName();

    public abstract List<Purpose> getPurposes();

    public abstract String getDescription();

    public final String getPurposesLabel() {
        StringBuilder sbf = new StringBuilder();
        LabelUtil labelUtil = LabelUtil.getInstance("OpenStego");
        List<Purpose> purposes = this.getPurposes();
        if (purposes == null || purposes.size() == 0) {
            return "";
        }
        sbf.append("(").append(labelUtil.getString("cmd.label.purpose.caption")).append(" ");
        for (int i = 0; i < purposes.size(); ++i) {
            if (i > 0) {
                sbf.append(", ");
            }
            sbf.append(labelUtil.getString("cmd.label.purpose." + (Object)((Object)purposes.get(i))));
        }
        sbf.append(")");
        return sbf.toString();
    }

    public abstract byte[] embedData(byte[] var1, String var2, byte[] var3, String var4, String var5) throws OpenStegoException;

    public abstract String extractMsgFileName(byte[] var1, String var2) throws OpenStegoException;

    public abstract byte[] extractData(byte[] var1, String var2, byte[] var3) throws OpenStegoException;

    public abstract byte[] generateSignature() throws OpenStegoException;

    public double checkMark(byte[] stegoData, String stegoFileName, byte[] origSigData) throws OpenStegoException {
        return this.getWatermarkCorrelation(origSigData, this.extractData(stegoData, stegoFileName, origSigData));
    }

    public abstract double getWatermarkCorrelation(byte[] var1, byte[] var2) throws OpenStegoException;

    public abstract double getHighWatermarkLevel() throws OpenStegoException;

    public abstract double getLowWatermarkLevel() throws OpenStegoException;

    public abstract byte[] getDiff(byte[] var1, String var2, byte[] var3, String var4, String var5) throws OpenStegoException;

    public abstract List<String> getReadableFileExtensions() throws OpenStegoException;

    public abstract List<String> getWritableFileExtensions() throws OpenStegoException;

    public abstract void populateStdCmdLineOptions(CmdLineOptions var1) throws OpenStegoException;

    public abstract String getUsage() throws OpenStegoException;

    public PluginEmbedOptionsUI getEmbedOptionsUI(OpenStegoFrame stegoFrame) {
        return null;
    }

    public C getConfig() {
        return this.config;
    }

    public void resetConfig() throws OpenStegoException {
        this.config = this.createConfig();
    }

    public void resetConfig(CmdLineOptions options) throws OpenStegoException {
        this.config = this.createConfig(options);
    }

    protected abstract C createConfig() throws OpenStegoException;

    protected abstract C createConfig(CmdLineOptions var1) throws OpenStegoException;

    public static enum Purpose {
        DATA_HIDING,
        WATERMARKING;

    }
}

