/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop;

import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.util.cmd.CmdLineOptions;
import java.util.HashMap;
import java.util.Map;

public class OpenStegoConfig {
    public static final String USE_COMPRESSION = "useCompression";
    public static final String USE_ENCRYPTION = "useEncryption";
    public static final String PASSWORD = "password";
    public static final String ENCRYPTION_ALGORITHM = "encryptionAlgorithm";
    private boolean useCompression = true;
    private boolean useEncryption = false;
    private String password = null;
    private String encryptionAlgorithm = "AES128";

    public final void initialize(Map<String, Object> propMap) throws OpenStegoException {
        this.addProperties(propMap);
    }

    public final void initialize(CmdLineOptions options) throws OpenStegoException {
        this.addProperties(this.convertCmdLineOptionsToMap(options));
    }

    protected Map<String, Object> convertCmdLineOptionsToMap(CmdLineOptions options) throws OpenStegoException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (options.getOption("-c") != null) {
            map.put(USE_COMPRESSION, true);
        }
        if (options.getOption("-C") != null) {
            map.put(USE_COMPRESSION, false);
        }
        if (options.getOption("-e") != null) {
            map.put(USE_ENCRYPTION, true);
        }
        if (options.getOption("-E") != null) {
            map.put(USE_ENCRYPTION, false);
        }
        if (options.getOption("-p") != null) {
            map.put(PASSWORD, options.getStringValue("-p"));
        }
        if (options.getOption("-A") != null) {
            map.put(ENCRYPTION_ALGORITHM, options.getStringValue("-A"));
        }
        return map;
    }

    protected void processConfigItem(String key, Object value) throws OpenStegoException {
        switch (key) {
            case "useCompression": {
                if (value == null) break;
                assert (value instanceof Boolean);
                this.useCompression = (Boolean)value;
                break;
            }
            case "useEncryption": {
                if (value == null) break;
                assert (value instanceof Boolean);
                this.useEncryption = (Boolean)value;
                break;
            }
            case "password": {
                assert (value instanceof String);
                this.password = (String)value;
                break;
            }
            case "encryptionAlgorithm": {
                assert (value instanceof String);
                this.encryptionAlgorithm = (String)value;
            }
        }
    }

    private void addProperties(Map<String, Object> propMap) throws OpenStegoException {
        for (Map.Entry<String, Object> entry : propMap.entrySet()) {
            this.processConfigItem(entry.getKey(), entry.getValue());
        }
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public boolean isUseEncryption() {
        return this.useEncryption;
    }

    public void setUseEncryption(boolean useEncryption) {
        this.useEncryption = useEncryption;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }
}

