/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.validation;

import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Optional;
import org.xml.sax.SAXParseException;

public class ConfigValidationIssue {
    private final Path file;
    private final String message;
    private final Throwable cause;
    private final boolean isError;

    public ConfigValidationIssue(Path file, String message, boolean isError, Throwable cause) {
        this.message = message;
        this.isError = isError;
        this.cause = cause;
        this.file = file;
    }

    private Optional<String> getLocation() {
        Throwable throwable = this.cause;
        if (throwable instanceof SAXParseException) {
            SAXParseException e = (SAXParseException)throwable;
            return Optional.of("%d:%d".formatted(e.getLineNumber(), e.getColumnNumber()));
        }
        return Optional.empty();
    }

    public String getMessage() {
        String severity = this.isError ? "Error" : "Warning";
        String label = this.getLocation().map(loc -> " at " + loc).orElse("");
        return "%s%s: %s".formatted(severity, label, this.message);
    }

    public Throwable getThrowable() {
        return this.cause;
    }

    public ConfigValidationIssue asWarning() {
        if (this.isError) {
            return new ConfigValidationIssue(this.file, this.message, false, this.cause);
        }
        return this;
    }

    public void printStackTrace(PrintStream stream) {
        if (this.cause == null) {
            stream.println("No stack trace available.");
            return;
        }
        this.cause.printStackTrace(stream);
    }

    public boolean isError() {
        return this.isError;
    }
}

