/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.IOException;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.server.startup.Bootloader;
import org.neo4j.server.startup.EnhancedExecutionContext;
import org.neo4j.server.startup.validation.ConfigValidationHelper;
import org.neo4j.server.startup.validation.ConfigValidationSummary;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="validate-config", description={"Validate configuration including Log4j."})
public class ValidateConfigCommand
extends AbstractCommand {
    private ConfigValidationHelper helper;
    public static final String COMMAND = "neo4j-admin server validate-config";

    public ValidateConfigCommand(ExecutionContext ctx) {
        this(ctx, null);
    }

    @VisibleForTesting
    public ValidateConfigCommand(ExecutionContext ctx, ConfigValidationHelper helper) {
        super(ctx);
        this.helper = helper;
    }

    protected void execute() throws CommandFailedException, IOException {
        EnhancedExecutionContext enhancedCtx = EnhancedExecutionContext.unwrapFromExecutionContext(this.ctx);
        try (Bootloader.Dbms bootloader = enhancedCtx.createDbmsBootloader();){
            if (this.helper == null) {
                this.helper = new ConfigValidationHelper(bootloader.confFile());
            }
            ConfigValidationSummary summary = this.helper.validateAll(() -> bootloader.fullConfig().getUnfiltered());
            summary.print(this.ctx.out(), this.verbose);
            summary.printClosingStatement(this.ctx.out());
            if (summary.result() == ConfigValidationSummary.ValidationResult.ERRORS) {
                throw new CommandFailedException("Configuration contains errors.", 78);
            }
        }
    }
}

