/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.internal.helpers.ProcessUtils;
import org.neo4j.server.startup.AbstractUnixBootloaderOs;
import org.neo4j.server.startup.Bootloader;

class UnixBootloaderOs
extends AbstractUnixBootloaderOs {
    private static final int MIN_ALLOWED_OPEN_FILES = 40000;

    UnixBootloaderOs(Bootloader ctx) {
        super(ctx);
    }

    private static int getFileHandleLimit() {
        try {
            String result = ProcessUtils.executeCommandWithOutput((String[])new String[]{"bash", "-c", "ulimit -n"}, (Duration)Duration.ofMinutes(1L));
            return StringUtils.isNumeric((CharSequence)result) ? Integer.parseInt(result) : Integer.MAX_VALUE;
        }
        catch (RuntimeException runtimeException) {
            return Integer.MAX_VALUE;
        }
    }

    @Override
    long start() {
        this.checkLimits();
        return super.start();
    }

    @Override
    long console() throws CommandFailedException {
        this.checkLimits();
        return super.console();
    }

    private void checkLimits() {
        int limit = UnixBootloaderOs.getFileHandleLimit();
        if (limit < 40000) {
            this.bootloader.environment.err().printf("WARNING: Max %s open files allowed, minimum of %s recommended. See the Neo4j manual.%n", limit, 40000);
        }
    }
}

