/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.PrintStream;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.server.startup.Bootloader;

public class EnhancedExecutionContext
extends ExecutionContext {
    private final Supplier<Bootloader.Dbms> dbmsBootloaderFactory;
    private final ClassLoader classloaderWithPlugins;

    public EnhancedExecutionContext(Path homeDir, Path confDir, PrintStream out, PrintStream err, FileSystemAbstraction fs, Supplier<Bootloader.Dbms> dbmsBootloaderFactory, ClassLoader pluginClassLoader) {
        super(homeDir, confDir, out, err, fs);
        this.dbmsBootloaderFactory = dbmsBootloaderFactory;
        this.classloaderWithPlugins = pluginClassLoader;
    }

    Bootloader.Dbms createDbmsBootloader() {
        return this.dbmsBootloaderFactory.get();
    }

    public ClassLoader getClassloaderWithPlugins() {
        return this.classloaderWithPlugins;
    }

    public static EnhancedExecutionContext unwrapFromExecutionContext(ExecutionContext executionContext) {
        if (executionContext instanceof EnhancedExecutionContext) {
            return (EnhancedExecutionContext)executionContext;
        }
        throw new IllegalStateException("The supplied execution context is not an enhanced execution context");
    }
}

