/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import picocli.CommandLine;

public class CommandLineArgs {
    @CommandLine.Option(names={"--home-dir"}, description={"path to NEO4J_HOME"})
    Path homeDir;
    @CommandLine.Option(names={"--config-dir"}, description={"path to a directory that contains a neo4j.conf file"}, converter={ConfigFileConverter.class})
    Path configFile;
    @CommandLine.Option(names={"--expand-commands"}, description={"allow execution of commands from the config"})
    boolean expandCommands;
    @CommandLine.Option(names={"--console-mode"}, description={"whether the bootstrapper should act as a console or daemon"})
    boolean consoleMode;
    @CommandLine.Option(names={"-c"}, mapFallbackValue="true", description={"override config values with -c key=value"})
    Map<String, String> configOverrides = Collections.emptyMap();

    private CommandLineArgs() {
    }

    public static CommandLineArgs parse(String ... args) {
        CommandLineArgs commandLineArgs = new CommandLineArgs();
        new CommandLine((Object)commandLineArgs).parseArgs(args);
        return commandLineArgs;
    }

    private static final class ConfigFileConverter
    implements CommandLine.ITypeConverter<Path> {
        private ConfigFileConverter() {
        }

        public Path convert(String value) {
            return value != null ? Path.of(value, "neo4j.conf") : null;
        }
    }
}

