/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph.versions;

import java.util.Iterator;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphVersion;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.dbms.systemgraph.versions.KnownCommunityTopologyComponentVersion;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;

public class CommunityTopologyComponentVersion_2_58
extends KnownCommunityTopologyComponentVersion {
    private final KnownCommunityTopologyComponentVersion previous;

    public CommunityTopologyComponentVersion_2_58(KnownCommunityTopologyComponentVersion previous) {
        super(CommunityTopologyGraphVersion.COMMUNITY_TOPOLOGY_58);
        this.previous = previous;
    }

    @Override
    public void upgradeTopologyGraph(Transaction tx, int fromVersion) throws Exception {
        if (fromVersion < this.version) {
            this.previous.upgradeTopologyGraph(tx, fromVersion);
            this.setVersionProperty(tx, this.version);
            this.addNamespaceProperties(tx);
        }
    }

    private void addNamespaceProperties(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL);){
            Iterators.forEachRemaining((Iterator)nodes, databaseNameNode -> {
                if (!databaseNameNode.hasProperty("displayName")) {
                    databaseNameNode.setProperty("displayName", databaseNameNode.getProperty("name"));
                }
            });
        }
    }
}

