/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database.readonly;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphDbmsModel;
import org.neo4j.dbms.systemgraph.SystemDatabaseProvider;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public final class SystemGraphReadOnlyDatabaseLookupFactory
implements ReadOnlyDatabases.LookupFactory {
    public static ReadonlyDatabasesProvider DEFAULT_PROVIDER = model -> model.getAllDatabaseAccess().entrySet().stream().filter(e -> e.getValue() == TopologyGraphDbmsModel.DatabaseAccess.READ_ONLY).map(e -> ((NamedDatabaseId)e.getKey()).databaseId());
    private final SystemDatabaseProvider systemDatabaseProvider;
    private final InternalLog log;
    private final Set<ReadonlyDatabasesProvider> providers;
    private volatile SystemGraphLookup previousLookup;

    public SystemGraphReadOnlyDatabaseLookupFactory(SystemDatabaseProvider systemDatabaseProvider, InternalLogProvider logProvider, Set<ReadonlyDatabasesProvider> providers) {
        this.systemDatabaseProvider = systemDatabaseProvider;
        this.previousLookup = SystemGraphLookup.ALWAYS_READONLY;
        this.log = logProvider.getLog(this.getClass());
        this.providers = providers;
    }

    public ReadOnlyDatabases.Lookup lookupReadOnlyDatabases() {
        SystemGraphLookup previous;
        SystemGraphLookup next = previous = this.previousLookup;
        try {
            next = this.systemDatabaseProvider.queryIfAvailable(this::lookupReadOnlyDatabases).map(set -> new SystemGraphLookup(false, (Set<DatabaseId>)set)).orElse(previous);
        }
        catch (Exception e) {
            this.log.warn("Unable to lookup readonly databases from the system database due to error! Using previous lookup %s.%nUnderlying error: %s", new Object[]{previous, e.getMessage()});
        }
        this.previousLookup = next;
        return next;
    }

    private Set<DatabaseId> lookupReadOnlyDatabases(Transaction tx) {
        CommunityTopologyGraphDbmsModel model = new CommunityTopologyGraphDbmsModel(tx);
        return this.providers.stream().flatMap(provider -> provider.getDatabaseIds(model)).collect(Collectors.toUnmodifiableSet());
    }

    private record SystemGraphLookup(boolean alwaysReadOnly, Set<DatabaseId> databaseIds) implements ReadOnlyDatabases.Lookup
    {
        private static final SystemGraphLookup ALWAYS_READONLY = new SystemGraphLookup(true, Set.of());

        public boolean databaseIsReadOnly(DatabaseId databaseId) {
            return this.alwaysReadOnly || this.databaseIds.contains(databaseId);
        }

        public ReadOnlyDatabases.Lookup.Source source() {
            return ReadOnlyDatabases.Lookup.Source.SYSTEM_GRAPH;
        }
    }

    public static interface ReadonlyDatabasesProvider {
        public Stream<DatabaseId> getDatabaseIds(CommunityTopologyGraphDbmsModel var1);
    }
}

