/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.api;

import java.nio.file.Path;
import java.util.Map;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilderImplementation;
import org.neo4j.dbms.api.Neo4jDatabaseManagementServiceBuilder;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.logging.LogProvider;

@PublicApi
public final class DatabaseManagementServiceBuilder
implements Neo4jDatabaseManagementServiceBuilder {
    private final Neo4jDatabaseManagementServiceBuilder implementation;

    public DatabaseManagementServiceBuilder(Path homeDirectory) {
        this.implementation = new DatabaseManagementServiceBuilderImplementation(homeDirectory, extension -> true);
    }

    @Override
    public DatabaseManagementService build() {
        return this.implementation.build();
    }

    @Override
    public DatabaseManagementServiceBuilder addDatabaseListener(DatabaseEventListener databaseEventListener) {
        this.implementation.addDatabaseListener(databaseEventListener);
        return this;
    }

    @Override
    public DatabaseManagementServiceBuilder setUserLogProvider(LogProvider userLogProvider) {
        this.implementation.setUserLogProvider(userLogProvider);
        return this;
    }

    @Override
    public <T> DatabaseManagementServiceBuilder setConfig(Setting<T> setting, T value) {
        this.implementation.setConfig(setting, value);
        return this;
    }

    @Override
    public DatabaseManagementServiceBuilder setConfig(Map<Setting<?>, Object> config) {
        this.implementation.setConfig(config);
        return this;
    }

    @Override
    public DatabaseManagementServiceBuilder loadPropertiesFromFile(Path path) {
        this.implementation.loadPropertiesFromFile(path);
        return this;
    }
}

