/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public final class Strings {
    public static final String TAB = "\t";

    private Strings() {
    }

    public static String prettyPrint(Object o) {
        if (o == null) {
            return "null";
        }
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            if (clazz == byte[].class) {
                return Arrays.toString((byte[])o);
            }
            if (clazz == short[].class) {
                return Arrays.toString((short[])o);
            }
            if (clazz == int[].class) {
                return Arrays.toString((int[])o);
            }
            if (clazz == long[].class) {
                return Arrays.toString((long[])o);
            }
            if (clazz == float[].class) {
                return Arrays.toString((float[])o);
            }
            if (clazz == double[].class) {
                return Arrays.toString((double[])o);
            }
            if (clazz == char[].class) {
                return Arrays.toString((char[])o);
            }
            if (clazz == boolean[].class) {
                return Arrays.toString((boolean[])o);
            }
            return Arrays.deepToString((Object[])o);
        }
        return String.valueOf(o);
    }

    public static String escape(String arg) {
        StringBuilder builder = new StringBuilder(arg.length());
        try {
            Strings.escape(builder, arg);
        }
        catch (IOException e) {
            throw new AssertionError("IOException from using StringBuilder", e);
        }
        return builder.toString();
    }

    public static String joinAsLines(String ... elements) {
        return String.join((CharSequence)System.lineSeparator(), elements);
    }

    public static void escape(Appendable output, String arg) throws IOException {
        int len = arg.length();
        block10: for (int i = 0; i < len; ++i) {
            char ch = arg.charAt(i);
            switch (ch) {
                case '\"': {
                    output.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    output.append("\\'");
                    continue block10;
                }
                case '\\': {
                    output.append("\\\\");
                    continue block10;
                }
                case '\n': {
                    output.append("\\n");
                    continue block10;
                }
                case '\t': {
                    output.append("\\t");
                    continue block10;
                }
                case '\r': {
                    output.append("\\r");
                    continue block10;
                }
                case '\b': {
                    output.append("\\b");
                    continue block10;
                }
                case '\f': {
                    output.append("\\f");
                    continue block10;
                }
                default: {
                    output.append(ch);
                }
            }
        }
    }

    public static IntStream codePoints(String s) {
        Iterable iterable = () -> new CodePointsIterator(s);
        return StreamSupport.stream(iterable.spliterator(), false).mapToInt(Integer::intValue);
    }

    private static class CodePointsIterator
    implements Iterator<Integer> {
        private String s;
        private int numCodePoints;
        private int charIndex;
        private int codePointIndex;

        public CodePointsIterator(String s) {
            this.s = s;
            this.numCodePoints = s.codePointCount(0, s.length());
            this.charIndex = 0;
            this.codePointIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.codePointIndex < this.numCodePoints;
        }

        @Override
        public Integer next() {
            int result = this.s.codePointAt(this.charIndex);
            this.charIndex = this.s.offsetByCodePoints(this.charIndex, 1);
            ++this.codePointIndex;
            return result;
        }
    }
}

