/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.DatabaseHealth;

@FunctionalInterface
public interface SystemDatabaseProvider {
    public GraphDatabaseAPI database() throws SystemDatabaseUnavailableException;

    default public void execute(Consumer<Transaction> consumer) throws SystemDatabaseUnavailableException {
        GraphDatabaseAPI facade = this.database();
        if (!facade.isAvailable(1000L)) {
            throw new SystemDatabaseUnavailableException();
        }
        try (Transaction tx = facade.beginTx();){
            consumer.accept(tx);
            tx.commit();
        }
    }

    default public <T> T query(Function<Transaction, T> function) throws SystemDatabaseUnavailableException {
        return SystemDatabaseProvider.query(this.database(), function, true).orElseThrow();
    }

    default public <T> Optional<T> queryIfAvailable(Function<Transaction, T> function) {
        return SystemDatabaseProvider.query(this.database(), function, false);
    }

    default public <T> Optional<T> dependency(Class<T> type) throws SystemDatabaseUnavailableException {
        return SystemDatabaseProvider.dependency(this.database().getDependencyResolver(), type);
    }

    public static <T> Optional<T> dependency(DependencyResolver dependencies, Class<T> type) throws SystemDatabaseUnavailableException {
        if (dependencies.containsDependency(type)) {
            return Optional.of(dependencies.resolveDependency(type));
        }
        return Optional.empty();
    }

    private static <T> Optional<T> query(GraphDatabaseAPI facade, Function<Transaction, T> function, boolean waitForAvailablity) throws SystemDatabaseUnavailableException {
        if (waitForAvailablity) {
            if (!facade.isAvailable(1000L)) {
                if (SystemDatabaseProvider.dependency(facade.getDependencyResolver(), DatabaseHealth.class).map(DatabaseHealth::hasNoPanic).orElse(true).booleanValue()) {
                    throw new SystemDatabaseUnavailableException();
                }
                throw new SystemDatabasePanickedException();
            }
        } else if (!facade.isAvailable()) {
            return Optional.empty();
        }
        try (Transaction tx = facade.beginTx();){
            T result = function.apply(tx);
            tx.commit();
            Optional<T> optional = Optional.of(result);
            return optional;
        }
    }

    public static class SystemDatabaseUnavailableException
    extends RuntimeException {
    }

    public static class SystemDatabasePanickedException
    extends SystemDatabaseUnavailableException {
    }
}

