/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.profile;

import org.neo4j.internal.helpers.Exceptions;

abstract class Profiler {
    private volatile RuntimeException failure;

    Profiler() {
    }

    void startProfiling() {
        this.failureSafeOp(this::start);
    }

    void stopProfiling() {
        this.failureSafeOp(this::stop);
    }

    RuntimeException failure() {
        return this.failure;
    }

    protected abstract boolean available();

    protected synchronized void setFailure(RuntimeException exception) {
        this.failure = (RuntimeException)Exceptions.chain((Throwable)this.failure, (Throwable)exception);
    }

    private void failureSafeOp(Runnable op) {
        try {
            op.run();
        }
        catch (RuntimeException exception) {
            this.setFailure(exception);
        }
    }

    protected abstract void start();

    protected abstract void stop();
}

