/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.backup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.neo4j.dbms.archive.StandardCompressionFormat;
import org.neo4j.dbms.archive.backup.BackupCompressionFormat;
import org.neo4j.dbms.archive.backup.BackupDescription;
import org.neo4j.dbms.archive.backup.BackupMetadataV1;

public class BackupZstdFormatV1
implements BackupCompressionFormat {
    static final String MAGIC_HEADER = "BZV1";
    private BackupMetadataV1 metadata;

    @Override
    public void setMetadata(BackupDescription description) {
        this.metadata = new BackupMetadataV1(description);
    }

    @Override
    public OutputStream compress(OutputStream stream) throws IOException {
        stream.write(MAGIC_HEADER.getBytes());
        OutputStream compressionStream = StandardCompressionFormat.ZSTD.compress(stream);
        try {
            this.metadata.writeToStreamV1(compressionStream);
            return compressionStream;
        }
        catch (IOException e) {
            compressionStream.close();
            throw e;
        }
    }

    @Override
    public InputStream decompress(InputStream stream) throws IOException {
        InputStream decompress = StandardCompressionFormat.ZSTD.decompress(stream);
        try {
            BackupZstdFormatV1.readMetadataFromZstdStream(decompress);
            return decompress;
        }
        catch (IOException e) {
            decompress.close();
            throw e;
        }
    }

    @Override
    public BackupCompressionFormat.StreamWithDescription decompressAndDescribe(InputStream stream) throws IOException {
        InputStream decompress = StandardCompressionFormat.ZSTD.decompress(stream);
        try {
            BackupDescription description = BackupZstdFormatV1.readMetadataFromZstdStream(decompress).toBackupDescription();
            return new BackupCompressionFormat.StreamWithDescription(decompress, description);
        }
        catch (IOException e) {
            decompress.close();
            throw e;
        }
    }

    @Override
    public BackupDescription readMetadata(InputStream inputStream) throws IOException {
        try (InputStream decompress = StandardCompressionFormat.ZSTD.decompress(inputStream);){
            BackupDescription backupDescription = BackupZstdFormatV1.readMetadataFromZstdStream(decompress).toBackupDescription();
            return backupDescription;
        }
    }

    private static BackupMetadataV1 readMetadataFromZstdStream(InputStream inputStream) throws IOException {
        return BackupMetadataV1.readFromStream(inputStream);
    }

    public String toString() {
        return "BackupZstdFormatV1{metadata=" + this.metadata + "}";
    }
}

