/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchimport.api.input;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.internal.id.IdSequence;

public interface InputEntityVisitor
extends Closeable {
    public static final InputEntityVisitor NULL = new Adapter();

    public boolean propertyId(long var1);

    public boolean properties(ByteBuffer var1, boolean var2);

    public boolean property(String var1, Object var2);

    public boolean property(int var1, Object var2);

    public boolean id(long var1);

    public boolean id(Object var1, Group var2);

    public boolean id(Object var1, Group var2, IdSequence var3);

    public boolean labels(String[] var1);

    public boolean labelField(long var1);

    public boolean startId(long var1);

    public boolean startId(Object var1, Group var2);

    public boolean endId(long var1);

    public boolean endId(Object var1, Group var2);

    public boolean type(int var1);

    public boolean type(String var1);

    public void endOfEntity() throws IOException;

    public void reset();

    public static class Adapter
    implements InputEntityVisitor {
        @Override
        public boolean property(String key, Object value) {
            return true;
        }

        @Override
        public boolean properties(ByteBuffer properties, boolean offloaded) {
            return true;
        }

        @Override
        public boolean property(int propertyKeyId, Object value) {
            return true;
        }

        @Override
        public boolean propertyId(long nextProp) {
            return true;
        }

        @Override
        public boolean id(long id) {
            return true;
        }

        @Override
        public boolean id(Object id, Group group) {
            return true;
        }

        @Override
        public boolean id(Object id, Group group, IdSequence idSequence) {
            return true;
        }

        @Override
        public boolean labels(String[] labels) {
            return true;
        }

        @Override
        public boolean startId(long id) {
            return true;
        }

        @Override
        public boolean startId(Object id, Group group) {
            return true;
        }

        @Override
        public boolean endId(long id) {
            return true;
        }

        @Override
        public boolean endId(Object id, Group group) {
            return true;
        }

        @Override
        public boolean type(int type) {
            return true;
        }

        @Override
        public boolean type(String type) {
            return true;
        }

        @Override
        public boolean labelField(long labelField) {
            return true;
        }

        @Override
        public void endOfEntity() {
        }

        @Override
        public void reset() {
        }

        @Override
        public void close() {
        }
    }

    public static class Delegate
    implements InputEntityVisitor {
        private final InputEntityVisitor actual;

        public Delegate(InputEntityVisitor actual) {
            this.actual = actual;
        }

        @Override
        public boolean propertyId(long nextProp) {
            return this.actual.propertyId(nextProp);
        }

        @Override
        public boolean properties(ByteBuffer properties, boolean offloaded) {
            return this.actual.properties(properties, offloaded);
        }

        @Override
        public boolean property(String key, Object value) {
            return this.actual.property(key, value);
        }

        @Override
        public boolean property(int propertyKeyId, Object value) {
            return this.actual.property(propertyKeyId, value);
        }

        @Override
        public boolean id(long id) {
            return this.actual.id(id);
        }

        @Override
        public boolean id(Object id, Group group) {
            return this.actual.id(id, group);
        }

        @Override
        public boolean id(Object id, Group group, IdSequence idSequence) {
            return this.actual.id(id, group, idSequence);
        }

        @Override
        public boolean labels(String[] labels) {
            return this.actual.labels(labels);
        }

        @Override
        public boolean labelField(long labelField) {
            return this.actual.labelField(labelField);
        }

        @Override
        public boolean startId(long id) {
            return this.actual.startId(id);
        }

        @Override
        public boolean startId(Object id, Group group) {
            return this.actual.startId(id, group);
        }

        @Override
        public boolean endId(long id) {
            return this.actual.endId(id);
        }

        @Override
        public boolean endId(Object id, Group group) {
            return this.actual.endId(id, group);
        }

        @Override
        public boolean type(int type) {
            return this.actual.type(type);
        }

        @Override
        public boolean type(String type) {
            return this.actual.type(type);
        }

        @Override
        public void endOfEntity() throws IOException {
            this.actual.endOfEntity();
        }

        @Override
        public void reset() {
            this.actual.reset();
        }

        @Override
        public void close() throws IOException {
            this.actual.close();
        }
    }
}

