/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.steps.index;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.Hint;
import org.neo4j.cypher.internal.ast.UsingIndexHint;
import org.neo4j.cypher.internal.compiler.planner.logical.LeafPlanRestrictions;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.RelationshipLeafPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.EntityIndexSeekPlanProvider$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.PredicateSet;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.RelationshipIndexLeafPlanner;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.index.RelationshipIndexPlanProvider;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.QueryExpression;
import org.neo4j.cypher.internal.logical.plans.RangeQueryExpression;
import org.neo4j.cypher.internal.logical.plans.SingleQueryExpression;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexQuery;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class RelationshipIndexSeekPlanProvider$
implements RelationshipIndexPlanProvider {
    public static final RelationshipIndexSeekPlanProvider$ MODULE$ = new RelationshipIndexSeekPlanProvider$();

    @Override
    public Set<LogicalPlan> createPlans(Set<RelationshipIndexLeafPlanner.RelationshipIndexMatch> indexMatches, QueryGraph queryGraph, LeafPlanRestrictions restrictions, LogicalPlanningContext context) {
        return (Set)indexMatches.withFilter((Function1 & Serializable)indexMatch -> BoxesRunTime.boxToBoolean((boolean)EntityIndexSeekPlanProvider$.MODULE$.isAllowedByRestrictions(indexMatch.propertyPredicates(), restrictions))).flatMap((Function1 & Serializable)indexMatch -> (Set)MODULE$.doCreatePlans((RelationshipIndexLeafPlanner.RelationshipIndexMatch)indexMatch, queryGraph, context).map((Function1 & Serializable)plan -> plan));
    }

    private Option<PredicateSet> predicateSetToSolve(RelationshipIndexLeafPlanner.RelationshipIndexMatch indexMatch, LogicalPlanningContext context, QueryGraph queryGraph) {
        PredicateSet predicateSet = indexMatch.predicateSet(EntityIndexSeekPlanProvider$.MODULE$.predicatesForIndexSeek(indexMatch.propertyPredicates()), true, context, queryGraph);
        if (predicateSet.propertyPredicates().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isExists()))) {
            return None$.MODULE$;
        }
        return new Some((Object)predicateSet);
    }

    private Set<LogicalPlan> doCreatePlans(RelationshipIndexLeafPlanner.RelationshipIndexMatch indexMatch, QueryGraph queryGraph, LogicalPlanningContext context) {
        Option<PredicateSet> predicateSet = this.predicateSetToSolve(indexMatch, context, queryGraph);
        return Option$.MODULE$.option2Iterable(predicateSet.map((Function1 & Serializable)x$2 -> MODULE$.constructPlan((PredicateSet)x$2, indexMatch, (Set<Hint>)queryGraph.hints(), (Set<LogicalVariable>)queryGraph.argumentIds(), context))).toSet();
    }

    private LogicalPlan constructPlan(PredicateSet predicateSet, RelationshipIndexLeafPlanner.RelationshipIndexMatch indexMatch, Set<Hint> hints2, Set<LogicalVariable> argumentIds, LogicalPlanningContext context) {
        QueryExpression<Expression> queryExpression = EntityIndexSeekPlanProvider$.MODULE$.mergeQueryExpressionsToSingleOne(predicateSet.propertyPredicates());
        Option hint2 = predicateSet.fulfilledHints(hints2, indexMatch.indexDescriptor().indexType(), false).headOption();
        QueryExpression<Expression> queryExpression2 = queryExpression;
        boolean supportsPartitionedScans = (queryExpression2 instanceof SingleQueryExpression ? true : queryExpression2 instanceof RangeQueryExpression) ? indexMatch.indexDescriptor().maybeKernelIndexCapability().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.supportPartitionedScan(new IndexQuery[]{PropertyIndexQuery.allEntries()}))) : false;
        return RelationshipLeafPlanner$.MODULE$.planHiddenSelectionAndRelationshipLeafPlan(argumentIds, indexMatch.patternRelationship(), context, (patternForLeafPlan, originalPattern, hiddenSelections) -> RelationshipIndexSeekPlanProvider$.getRelationshipLeafPlan$1(patternForLeafPlan, originalPattern, hiddenSelections, context, indexMatch, predicateSet, queryExpression, argumentIds, hint2, supportsPartitionedScans));
    }

    private static final LogicalPlan getRelationshipLeafPlan$1(PatternRelationship patternForLeafPlan, PatternRelationship originalPattern, Seq hiddenSelections, LogicalPlanningContext context$3, RelationshipIndexLeafPlanner.RelationshipIndexMatch indexMatch$2, PredicateSet predicateSet$1, QueryExpression queryExpression$1, Set argumentIds$1, Option hint$1, boolean supportsPartitionedScans$1) {
        return context$3.staticComponents().logicalPlanProducer().planRelationshipIndexSeek(indexMatch$2.variable(), indexMatch$2.relationshipTypeToken(), predicateSet$1.indexedProperties(context$3), (QueryExpression<Expression>)queryExpression$1, (Set<LogicalVariable>)argumentIds$1, indexMatch$2.indexOrder(), patternForLeafPlan, originalPattern, predicateSet$1.allSolvedPredicates(), (Option<UsingIndexHint>)hint$1, (Seq<Expression>)hiddenSelections, indexMatch$2.providedOrder(), context$3, indexMatch$2.indexDescriptor().indexType(), indexMatch$2.indexDescriptor().isUnique(), supportsPartitionedScans$1);
    }

    private RelationshipIndexSeekPlanProvider$() {
    }
}

