/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.composite;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.Clause;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.PlannerQueryBuilder;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.PlannerQueryBuilder$;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.StatementConverters$;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.composite.CompositeQuery;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.composite.CompositeQuery$Union$Type$All$;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.composite.CompositeQuery$Union$Type$Distinct$;
import org.neo4j.cypher.internal.compiler.helpers.SeqSupport$;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.QueryProjection;
import org.neo4j.cypher.internal.ir.RunQueryAtProjection;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.UnionQuery;
import org.neo4j.cypher.internal.util.AnonymousVariableNameGenerator;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.rendering.QueryRenderer$;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.immutable.Seq;

public final class CompositeQueryConverter$ {
    public static final CompositeQueryConverter$ MODULE$ = new CompositeQueryConverter$();

    public PlannerQuery convert(CancellationChecker cancellationChecker, AnonymousVariableNameGenerator nameGenerator, SemanticTable semanticTable, CompositeQuery query) {
        CompositeQuery compositeQuery = query;
        if (compositeQuery instanceof CompositeQuery.Single.Foreign) {
            CompositeQuery.Single.Foreign foreign = (CompositeQuery.Single.Foreign)compositeQuery;
            return this.convertForeign(semanticTable, foreign);
        }
        if (compositeQuery instanceof CompositeQuery.Single.Fragments) {
            CompositeQuery.Single.Fragments fragments = (CompositeQuery.Single.Fragments)compositeQuery;
            return this.convertTopLevelFragments(cancellationChecker, nameGenerator, semanticTable, fragments);
        }
        if (compositeQuery instanceof CompositeQuery.Union) {
            CompositeQuery.Union union = (CompositeQuery.Union)compositeQuery;
            return this.convertUnion(cancellationChecker, nameGenerator, semanticTable, union);
        }
        throw new MatchError((Object)compositeQuery);
    }

    private SinglePlannerQuery convertForeign(SemanticTable semanticTable, CompositeQuery.Single.Foreign foreign) {
        scala.collection.immutable.Set argumentIds = (scala.collection.immutable.Set)foreign.importsAsParameters().view().values().toSet().union((Set)((Expression)foreign.graphReference()).dependencies());
        PlannerQueryBuilder builder = PlannerQueryBuilder$.MODULE$.apply(semanticTable, (scala.collection.immutable.Set<LogicalVariable>)argumentIds);
        return builder.withHorizon((QueryHorizon)new RunQueryAtProjection(foreign.graphReference(), QueryRenderer$.MODULE$.render(foreign.clauses()), foreign.parameters(), foreign.importsAsParameters(), ((Clause)foreign.clauses().last()).returnVariables().explicitVariables().toSet(), Predef$.MODULE$.Set().empty())).build();
    }

    /*
     * Unable to fully structure code
     */
    private SinglePlannerQuery convertTopLevelFragments(CancellationChecker cancellationChecker, AnonymousVariableNameGenerator nameGenerator, SemanticTable semanticTable, CompositeQuery.Single.Fragments fragments) {
        builder = PlannerQueryBuilder$.MODULE$.apply(semanticTable, (scala.collection.immutable.Set<LogicalVariable>)Predef$.MODULE$.Set().empty());
        var8_6 = SeqSupport$.MODULE$.RichSeq(fragments.fragments()).initAndLastOption();
        if (!(var8_6 instanceof Some) || (var10_8 = (Tuple2)(var9_7 = (Some)var8_6).value()) == null) ** GOTO lbl-1000
        initFragments = (Seq)var10_8._1();
        var12_10 = (CompositeQuery.Fragment)var10_8._2();
        if (var12_10 instanceof CompositeQuery.Fragment.Standard) {
            var13_11 = (CompositeQuery.Fragment.Standard)var12_10;
            lastClauses = var13_11.clauses();
            withInitFragments = this.addFragmentsToPlannerQueryBuilder(cancellationChecker, nameGenerator, semanticTable, builder, (Seq<CompositeQuery.Fragment>)initFragments);
            v0 = StatementConverters$.MODULE$.addClausesToPlannerQueryBuilder(lastClauses, withInitFragments, nameGenerator, cancellationChecker, (QueryProjection.Position)QueryProjection.Position$.Final$.MODULE$);
        } else lbl-1000:
        // 2 sources

        {
            v0 = this.addFragmentsToPlannerQueryBuilder(cancellationChecker, nameGenerator, semanticTable, builder, fragments.fragments());
        }
        withFragments = v0;
        return withFragments.build();
    }

    private PlannerQuery convertUnion(CancellationChecker cancellationChecker, AnonymousVariableNameGenerator nameGenerator, SemanticTable semanticTable, CompositeQuery.Union union) {
        return new UnionQuery(this.convertNestedQuery(cancellationChecker, nameGenerator, semanticTable, union.lhs()), this.convertNestedSingle(cancellationChecker, nameGenerator, semanticTable, union.rhs()), this.isDistinct(union.unionType()), union.unionMappings());
    }

    private boolean isDistinct(CompositeQuery.Union.Type unionType) {
        CompositeQuery.Union.Type type = unionType;
        if (CompositeQuery$Union$Type$All$.MODULE$.equals(type)) {
            return false;
        }
        if (CompositeQuery$Union$Type$Distinct$.MODULE$.equals(type)) {
            return true;
        }
        throw new MatchError((Object)type);
    }

    private PlannerQuery convertNestedQuery(CancellationChecker cancellationChecker, AnonymousVariableNameGenerator nameGenerator, SemanticTable semanticTable, CompositeQuery query) {
        CompositeQuery compositeQuery = query;
        if (compositeQuery instanceof CompositeQuery.Single) {
            CompositeQuery.Single single = (CompositeQuery.Single)compositeQuery;
            return this.convertNestedSingle(cancellationChecker, nameGenerator, semanticTable, single);
        }
        if (compositeQuery instanceof CompositeQuery.Union) {
            CompositeQuery.Union union = (CompositeQuery.Union)compositeQuery;
            return this.convertUnion(cancellationChecker, nameGenerator, semanticTable, union);
        }
        throw new MatchError((Object)compositeQuery);
    }

    private SinglePlannerQuery convertNestedSingle(CancellationChecker cancellationChecker, AnonymousVariableNameGenerator nameGenerator, SemanticTable semanticTable, CompositeQuery.Single single) {
        CompositeQuery.Single single2 = single;
        if (single2 instanceof CompositeQuery.Single.Foreign) {
            CompositeQuery.Single.Foreign foreign = (CompositeQuery.Single.Foreign)single2;
            return this.convertForeign(semanticTable, foreign);
        }
        if (single2 instanceof CompositeQuery.Single.Fragments) {
            CompositeQuery.Single.Fragments fragments = (CompositeQuery.Single.Fragments)single2;
            PlannerQueryBuilder builder = PlannerQueryBuilder$.MODULE$.apply(semanticTable, fragments.arguments());
            PlannerQueryBuilder withFragments = this.addFragmentsToPlannerQueryBuilder(cancellationChecker, nameGenerator, semanticTable, builder, fragments.fragments());
            return withFragments.build();
        }
        throw new MatchError((Object)single2);
    }

    private PlannerQueryBuilder addFragmentsToPlannerQueryBuilder(CancellationChecker cancellationChecker, AnonymousVariableNameGenerator nameGenerator, SemanticTable semanticTable, PlannerQueryBuilder builder2, Seq<CompositeQuery.Fragment> fragments) {
        cancellationChecker.throwIfCancelled();
        return (PlannerQueryBuilder)fragments.foldLeft((Object)builder2, (Function2 & Serializable)(builder, fragment) -> {
            CompositeQuery.Fragment fragment2 = fragment;
            if (fragment2 instanceof CompositeQuery.Fragment.Standard) {
                CompositeQuery.Fragment.Standard standard = (CompositeQuery.Fragment.Standard)fragment2;
                return StatementConverters$.MODULE$.addClausesToPlannerQueryBuilder(standard.clauses(), (PlannerQueryBuilder)builder, nameGenerator, cancellationChecker, (QueryProjection.Position)QueryProjection.Position$.Intermediate$.MODULE$);
            }
            if (fragment2 instanceof CompositeQuery.Fragment.SubQuery) {
                CompositeQuery.Fragment.SubQuery subQuery = (CompositeQuery.Fragment.SubQuery)fragment2;
                return builder.withCallSubquery(MODULE$.convertNestedQuery(cancellationChecker, nameGenerator, semanticTable, subQuery.innerQuery()), subQuery.isCorrelated(), subQuery.isYielding(), subQuery.inTransactionsParameters(), subQuery.optional(), (scala.collection.immutable.Set<LogicalVariable>)Predef$.MODULE$.Set().empty());
            }
            throw new MatchError((Object)fragment2);
        });
    }

    private CompositeQueryConverter$() {
    }
}

