/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharReadableChunker;
import org.neo4j.csv.reader.HeaderSkipper;
import org.neo4j.csv.reader.Source;

public abstract class NewLineChunker
extends CharReadableChunker {
    private final HeaderSkipper headerSkip;
    private String lastSeenSourceDescription;
    private int fileIndex = -1;
    private long totalBackCopied;

    protected NewLineChunker(CharReadable reader, int chunkSize, HeaderSkipper headerSkip) {
        super(reader, chunkSize);
        this.headerSkip = headerSkip;
    }

    protected abstract int offsetOfLastRow(char[] var1);

    @Override
    public synchronized boolean nextChunk(Source.Chunk chunk) throws IOException {
        CharReadableChunker.ChunkImpl into = (CharReadableChunker.ChunkImpl)chunk;
        char[] chunkBuffer = into.buffer;
        int offset = this.fillFromBackBuffer(chunkBuffer);
        int leftToRead = this.chunkSize - offset;
        int read = this.reader.read(chunkBuffer, offset, leftToRead);
        Emit emit = Emit.NO;
        if (read > 0) {
            if (read == leftToRead) {
                int newlineOffset = this.offsetOfLastRow(chunkBuffer) + 1;
                int backCopied = this.storeInBackBuffer(chunkBuffer, newlineOffset, this.chunkSize - newlineOffset);
                this.totalBackCopied += (long)backCopied;
                read -= backCopied;
                emit = Emit.YES_WITH_BACK_COPY;
            } else {
                emit = Emit.YES_NO_BACK_COPY;
            }
            offset += read;
        } else if (offset > 0) {
            emit = Emit.YES_ONLY_BACK_FILLED;
        }
        boolean newSource = this.crossedOverToNewSource();
        if (emit.send) {
            if (emit.updateWithRead) {
                this.position += (long)read;
            }
            if (emit.updateWithBackCopied) {
                this.position += this.totalBackCopied;
                this.totalBackCopied = 0L;
            }
            int skipped = newSource && this.fileIndex >= 0 ? this.headerSkip.skipHeader(chunkBuffer, 0, offset) : 0;
            into.initialize(skipped, offset - skipped, this.lastSeenSourceDescription);
            return true;
        }
        return false;
    }

    private boolean crossedOverToNewSource() {
        String currentSourceDescription = this.reader.sourceDescription();
        if (!currentSourceDescription.equals(this.lastSeenSourceDescription)) {
            ++this.fileIndex;
            this.lastSeenSourceDescription = currentSourceDescription;
            return true;
        }
        return false;
    }

    private static enum Emit {
        YES_WITH_BACK_COPY(true, true, false),
        YES_NO_BACK_COPY(true, true, true),
        YES_ONLY_BACK_FILLED(true, false, true),
        NO(false, false, false);

        private final boolean send;
        private final boolean updateWithRead;
        private final boolean updateWithBackCopied;

        private Emit(boolean send, boolean updateWithRead, boolean updateWithBackCopied) {
            this.send = send;
            this.updateWithRead = updateWithRead;
            this.updateWithBackCopied = updateWithBackCopied;
        }
    }
}

