/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class Magic {
    public static final Magic NONE = new Magic("NONE", null, ArrayUtils.EMPTY_BYTE_ARRAY);
    private static final List<Magic> DEFINITIONS = new ArrayList<Magic>();
    private static int LONGEST;
    public static final Magic ZIP;
    public static final Magic GZIP;
    public static final Magic BOM_UTF_32_BE;
    public static final Magic BOM_UTF_32_LE;
    public static final Magic BOM_UTF_16_BE;
    public static final Magic BOM_UTF_16_LE;
    public static final Magic BOM_UTF_8;
    private final String description;
    private final Charset encoding;
    private final byte[] bytes;

    public static Magic define(String description, Charset impliesEncoding, int ... bytesAsIntsForConvenience) {
        byte[] bytes = new byte[bytesAsIntsForConvenience.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)bytesAsIntsForConvenience[i];
        }
        Magic magic = new Magic(description, impliesEncoding, bytes);
        DEFINITIONS.add(magic);
        LONGEST = Math.max(LONGEST, bytes.length);
        return magic;
    }

    public static Magic of(byte[] bytes) {
        for (Magic candidate : DEFINITIONS) {
            if (!candidate.matches(bytes)) continue;
            return candidate;
        }
        return NONE;
    }

    public static int longest() {
        return LONGEST;
    }

    private Magic(String description, Charset encoding, byte[] bytes) {
        this.description = description;
        this.encoding = encoding;
        this.bytes = bytes;
    }

    public boolean matches(byte[] candidateBytes) {
        if (candidateBytes.length < this.bytes.length) {
            return false;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (candidateBytes[i] == this.bytes[i]) continue;
            return false;
        }
        return true;
    }

    public int length() {
        return this.bytes.length;
    }

    public boolean impliesEncoding() {
        return this.encoding != null;
    }

    public Charset encoding() {
        if (this.encoding == null) {
            throw new IllegalStateException(this + " doesn't imply any specific encoding");
        }
        return this.encoding;
    }

    byte[] bytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public String toString() {
        return "Magic[" + this.description + ", " + Arrays.toString(this.bytes) + "]";
    }

    static {
        ZIP = Magic.define("ZIP", null, 80, 75, 3, 4);
        GZIP = Magic.define("GZIP", null, 31, 139);
        BOM_UTF_32_BE = Magic.define("BOM_UTF_32_BE", Charset.forName("UTF-32"), 0, 0, 254, 255);
        BOM_UTF_32_LE = Magic.define("BOM_UTF_32_LE", Charset.forName("UTF-32"), 255, 254, 0, 0);
        BOM_UTF_16_BE = Magic.define("BOM_UTF_16_BE", StandardCharsets.UTF_16BE, 254, 255);
        BOM_UTF_16_LE = Magic.define("BOM_UTF_16_LE", StandardCharsets.UTF_16LE, 255, 254);
        BOM_UTF_8 = Magic.define("BOM_UTF8", StandardCharsets.UTF_8, 239, 187, 191);
    }
}

