/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.auth2;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.grpc.Metadata;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.auth2.AuthUtilities;
import org.apache.arrow.flight.auth2.BearerTokenAuthenticator;
import org.apache.arrow.flight.auth2.CallHeaderAuthenticator;
import org.apache.arrow.flight.grpc.MetadataAdapter;

public class GeneratedBearerTokenAuthenticator
extends BearerTokenAuthenticator {
    private final Cache<String, String> bearerToIdentityCache;

    public GeneratedBearerTokenAuthenticator(CallHeaderAuthenticator authenticator) {
        this(authenticator, (CacheBuilder<Object, Object>)CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS));
    }

    public GeneratedBearerTokenAuthenticator(CallHeaderAuthenticator authenticator, int timeoutMinutes) {
        this(authenticator, (CacheBuilder<Object, Object>)CacheBuilder.newBuilder().expireAfterAccess((long)timeoutMinutes, TimeUnit.MINUTES));
    }

    public GeneratedBearerTokenAuthenticator(CallHeaderAuthenticator authenticator, CacheBuilder<Object, Object> cacheBuilder) {
        super(authenticator);
        this.bearerToIdentityCache = cacheBuilder.build();
    }

    @Override
    protected CallHeaderAuthenticator.AuthResult validateBearer(final String bearerToken) {
        final String peerIdentity = (String)this.bearerToIdentityCache.getIfPresent((Object)bearerToken);
        if (peerIdentity == null) {
            throw CallStatus.UNAUTHENTICATED.toRuntimeException();
        }
        return new CallHeaderAuthenticator.AuthResult(){

            @Override
            public String getPeerIdentity() {
                return peerIdentity;
            }

            @Override
            public void appendToOutgoingHeaders(CallHeaders outgoingHeaders) {
                if (null == AuthUtilities.getValueFromAuthHeader(outgoingHeaders, "Bearer ")) {
                    outgoingHeaders.insert("Authorization", "Bearer " + bearerToken);
                }
            }
        };
    }

    @Override
    protected CallHeaderAuthenticator.AuthResult getAuthResultWithBearerToken(final CallHeaderAuthenticator.AuthResult authResult) {
        CallHeaderAuthenticator.AuthResult authResultWithBearerToken;
        MetadataAdapter dummyHeaders = new MetadataAdapter(new Metadata());
        authResult.appendToOutgoingHeaders(dummyHeaders);
        String bearerToken = AuthUtilities.getValueFromAuthHeader(dummyHeaders, "Bearer ");
        if (Strings.isNullOrEmpty((String)bearerToken)) {
            String newToken;
            UUID uuid = UUID.randomUUID();
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
            byteBuffer.putLong(uuid.getMostSignificantBits());
            byteBuffer.putLong(uuid.getLeastSignificantBits());
            bearerToken = newToken = Base64.getEncoder().encodeToString(byteBuffer.array());
            authResultWithBearerToken = new CallHeaderAuthenticator.AuthResult(){

                @Override
                public String getPeerIdentity() {
                    return authResult.getPeerIdentity();
                }

                @Override
                public void appendToOutgoingHeaders(CallHeaders outgoingHeaders) {
                    authResult.appendToOutgoingHeaders(outgoingHeaders);
                    outgoingHeaders.insert("Authorization", "Bearer " + newToken);
                }
            };
        } else {
            authResultWithBearerToken = authResult;
        }
        this.bearerToIdentityCache.put((Object)bearerToken, (Object)authResult.getPeerIdentity());
        return authResultWithBearerToken;
    }
}

