/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.auth;

import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.flight.grpc.StatusUtils;
import org.apache.arrow.flight.impl.Flight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAuthWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAuthWrapper.class);

    public static StreamObserver<Flight.HandshakeRequest> wrapHandshake(ServerAuthHandler authHandler, StreamObserver<Flight.HandshakeResponse> responseObserver, ExecutorService executors) {
        AuthObserver observer = new AuthObserver(responseObserver);
        Runnable r = () -> {
            try {
                if (authHandler.authenticate(observer.sender, observer.iter)) {
                    responseObserver.onCompleted();
                    return;
                }
                responseObserver.onError(StatusUtils.toGrpcException(CallStatus.UNAUTHENTICATED.toRuntimeException()));
            }
            catch (Exception ex) {
                LOGGER.error("Error during authentication", (Throwable)ex);
                responseObserver.onError(StatusUtils.toGrpcException(ex));
            }
        };
        observer.future = executors.submit(r);
        return observer;
    }

    private static class AuthObserver
    implements StreamObserver<Flight.HandshakeRequest> {
        private final StreamObserver<Flight.HandshakeResponse> responseObserver;
        private volatile Future<?> future;
        private volatile boolean completed = false;
        private final LinkedBlockingQueue<byte[]> messages = new LinkedBlockingQueue();
        private final AuthSender sender = new AuthSender();
        private Iterator<byte[]> iter = new Iterator<byte[]>(){

            @Override
            public byte[] next() {
                while (!completed || !messages.isEmpty()) {
                    byte[] bytes = (byte[])messages.poll();
                    if (bytes == null) continue;
                    return bytes;
                }
                throw new IllegalStateException("Requesting more messages than client sent.");
            }

            @Override
            public boolean hasNext() {
                return !messages.isEmpty();
            }
        };

        public AuthObserver(StreamObserver<Flight.HandshakeResponse> responseObserver) {
            this.responseObserver = responseObserver;
        }

        public void onNext(Flight.HandshakeRequest value) {
            ByteString payload = value.getPayload();
            if (payload != null) {
                this.messages.add(payload.toByteArray());
            }
        }

        public void onError(Throwable t) {
            this.completed = true;
            while (this.future == null) {
            }
            this.future.cancel(true);
        }

        public void onCompleted() {
            this.completed = true;
        }

        private class AuthSender
        implements ServerAuthHandler.ServerAuthSender {
            private AuthSender() {
            }

            @Override
            public void send(byte[] payload) {
                AuthObserver.this.responseObserver.onNext((Object)Flight.HandshakeResponse.newBuilder().setPayload(ByteString.copyFrom((byte[])payload)).build());
            }

            @Override
            public void onError(Throwable cause) {
                AuthObserver.this.responseObserver.onError(StatusUtils.toGrpcException(cause));
            }
        }
    }
}

