/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.arrow.flight.CancelStatus;
import org.apache.arrow.flight.impl.Flight;

public class CancelFlightInfoResult {
    private final CancelStatus status;

    public CancelFlightInfoResult(CancelStatus status) {
        this.status = status;
    }

    CancelFlightInfoResult(Flight.CancelFlightInfoResult proto) {
        switch (proto.getStatus()) {
            case CANCEL_STATUS_UNSPECIFIED: {
                this.status = CancelStatus.UNSPECIFIED;
                break;
            }
            case CANCEL_STATUS_CANCELLED: {
                this.status = CancelStatus.CANCELLED;
                break;
            }
            case CANCEL_STATUS_CANCELLING: {
                this.status = CancelStatus.CANCELLING;
                break;
            }
            case CANCEL_STATUS_NOT_CANCELLABLE: {
                this.status = CancelStatus.NOT_CANCELLABLE;
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
    }

    public CancelStatus getStatus() {
        return this.status;
    }

    Flight.CancelFlightInfoResult toProtocol() {
        Flight.CancelFlightInfoResult.Builder b = Flight.CancelFlightInfoResult.newBuilder();
        switch (this.status) {
            case UNSPECIFIED: {
                b.setStatus(Flight.CancelStatus.CANCEL_STATUS_UNSPECIFIED);
                break;
            }
            case CANCELLED: {
                b.setStatus(Flight.CancelStatus.CANCEL_STATUS_CANCELLED);
                break;
            }
            case CANCELLING: {
                b.setStatus(Flight.CancelStatus.CANCEL_STATUS_CANCELLING);
                break;
            }
            case NOT_CANCELLABLE: {
                b.setStatus(Flight.CancelStatus.CANCEL_STATUS_NOT_CANCELLABLE);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return b.build();
    }

    public ByteBuffer serialize() {
        return ByteBuffer.wrap(this.toProtocol().toByteArray());
    }

    public static CancelFlightInfoResult deserialize(ByteBuffer serialized) throws IOException {
        return new CancelFlightInfoResult(Flight.CancelFlightInfoResult.parseFrom(serialized));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CancelFlightInfoResult)) {
            return false;
        }
        CancelFlightInfoResult that = (CancelFlightInfoResult)o;
        return this.status == that.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status});
    }

    public String toString() {
        return "CancelFlightInfoResult{status=" + (Object)((Object)this.status) + '}';
    }
}

