/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;

public class LogFilesMatcher {
    private final TransactionLogFilesHelper checkpointFilesHelper;
    private final TransactionLogFilesHelper transactionLogFilesHelper;

    public LogFilesMatcher(FileSystemAbstraction fileSystem, Path logFilesDirectory) {
        this.transactionLogFilesHelper = TransactionLogFilesHelper.forTransactions(fileSystem, logFilesDirectory);
        this.checkpointFilesHelper = TransactionLogFilesHelper.forCheckpoints(fileSystem, logFilesDirectory);
    }

    public Path[] getCheckpointLogFiles() throws IOException {
        return this.checkpointFilesHelper.getMatchedFiles();
    }

    public Path[] getTransactionLogFiles() throws IOException {
        return this.transactionLogFilesHelper.getMatchedFiles();
    }

    public boolean hasAnyLogFiles() {
        try {
            return this.getTransactionLogFiles().length > 0 || this.getCheckpointLogFiles().length > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isLogFile(Path file) {
        return this.transactionLogFilesHelper.isLogFile(file) || this.checkpointFilesHelper.isLogFile(file);
    }
}

