/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.Objects;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractVersionAwareLogEntry;
import org.neo4j.string.Mask;

public class LogEntryCommit
extends AbstractVersionAwareLogEntry {
    protected final long txId;
    protected final long timeWritten;

    protected LogEntryCommit(KernelVersion kernelVersion, long txId, long timeWritten) {
        super(kernelVersion, (byte)5);
        this.txId = txId;
        this.timeWritten = timeWritten;
    }

    public long getTxId() {
        return this.txId;
    }

    public long getTimeWritten() {
        return this.timeWritten;
    }

    public int getChecksum() {
        return 0;
    }

    public String toString(Mask mask) {
        return "Commit[txId=" + this.getTxId() + ", " + this.timestamp(this.getTimeWritten()) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryCommit that = (LogEntryCommit)o;
        return this.txId == that.txId && this.timeWritten == that.timeWritten;
    }

    public int hashCode() {
        return Objects.hash(this.txId, this.timeWritten);
    }
}

