/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.file.Path;

public class IncompleteLogHeaderException
extends IOException {
    public IncompleteLogHeaderException(Path file, int readSize, int expectedSize) {
        super(IncompleteLogHeaderException.template(file, readSize, expectedSize));
    }

    public IncompleteLogHeaderException(int readSize, int expectedSize) {
        super(IncompleteLogHeaderException.template(null, readSize, expectedSize));
    }

    private static String template(Path file, int readSize, int expectedSize) {
        StringBuilder builder = new StringBuilder("Unable to read log version and last committed tx");
        if (file != null) {
            builder.append(" from '").append(file.toAbsolutePath()).append('\'');
        }
        builder.append(". Was only able to read ").append(readSize).append(" bytes, but was expecting ").append(expectedSize);
        return builder.toString();
    }
}

