/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.neo4j.cli.CommandGroup;
import org.neo4j.cli.CommandProvider;
import org.neo4j.cli.CommandType;
import org.neo4j.cli.ContextInjectingFactory;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.kernel.internal.Version;
import org.neo4j.service.Services;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="neo4j-admin", description={"Neo4j database administration tool."}, mixinStandardHelpOptions=true, versionProvider=VersionProvider.class, footerHeading="\nEnvironment variables:\n", subcommands={VersionCommand.class, CommandLine.HelpCommand.class}, footer={"  NEO4J_CONF    Path to directory which contains neo4j.conf.", "  NEO4J_DEBUG   Set to anything to enable debug output.", "  NEO4J_HOME    Neo4j home directory.", "  HEAP_SIZE     Set JVM maximum heap size during command execution. Takes a number and a unit, for example 512m.", "  JAVA_OPTS     Used to pass custom setting to Java Virtual Machine executing the command. Refer to JVM documentation about the exact format. This variable is incompatible with HEAP_SIZE and takes precedence over HEAP_SIZE."})
public class AdminTool {
    private static final String ENV_NEO4J_HOME = "NEO4J_HOME";
    private static final String ENV_NEO4J_CONF = "NEO4J_CONF";
    @CommandLine.Option(names={"--expand-commands"}, description={"Allow command expansion in config value evaluation."})
    private boolean expandCommands;
    @CommandLine.Option(names={"--verbose"}, description={"Prints additional information."})
    private boolean verbose;

    protected AdminTool() {
    }

    public static void main(String[] args) {
        Path homeDir = AdminTool.getHomeDir();
        Path confDir = AdminTool.getConfDir(homeDir);
        ExecutionContext ctx = new ExecutionContext(homeDir, confDir);
        int exitCode = AdminTool.execute(ctx, args);
        System.exit(exitCode);
    }

    @VisibleForTesting
    public static int execute(ExecutionContext ctx, String ... args) {
        CommandLine cmd = AdminTool.getCommandLine(ctx);
        if (args.length == 0) {
            cmd.usage(cmd.getOut());
            return 64;
        }
        return cmd.execute(args);
    }

    public static CommandLine getCommandLine(final ExecutionContext ctx) {
        return AdminTool.getCommandLine(ctx, new Strategy(){

            @Override
            public AdminTool createRootCommand() {
                return new AdminTool();
            }

            @Override
            public void registerCommandsFromGroup(CommandGroup commandGroup, CommandLine commandLine, Collection<CommandProvider> commandProviders) {
                CommandLine.Model.UsageMessageSpec messageSpec = new CommandLine.Model.UsageMessageSpec().description(new String[]{commandGroup.getDescription()});
                CommandLine.Model.CommandSpec commandSpec = CommandLine.Model.CommandSpec.create().name(commandGroup.getDisplayName()).usageMessage(messageSpec);
                CommandLine groupCommandLine = new CommandLine((Object)commandSpec, (CommandLine.IFactory)new ContextInjectingFactory(ctx)).addSubcommand(null, CommandLine.HelpCommand.class, new String[]{"-h", "--help"});
                AdminTool.registerGroupCommands(commandProviders, commandGroup, ctx, groupCommandLine, type -> true);
                commandLine.addSubcommand((Object)groupCommandLine);
            }
        });
    }

    protected static CommandLine getCommandLine(ExecutionContext ctx, Strategy strategy) {
        CommandLine cmd = new CommandLine((Object)strategy.createRootCommand(), (CommandLine.IFactory)new ContextInjectingFactory(ctx));
        AdminTool.registerCommands(cmd, strategy, Services.loadAll(CommandProvider.class));
        cmd.setOut(new PrintWriter(ctx.out(), true)).setErr(new PrintWriter(ctx.err(), true)).setUsageHelpWidth(120).setCaseInsensitiveEnumValuesAllowed(true);
        return cmd;
    }

    private static void registerCommands(CommandLine cmd, Strategy strategy, Collection<CommandProvider> commandProviders) {
        for (CommandGroup commandGroup : CommandGroup.values()) {
            strategy.registerCommandsFromGroup(commandGroup, cmd, commandProviders);
        }
    }

    private static void registerGroupCommands(Collection<CommandProvider> commandProviders, CommandGroup commandGroup, ExecutionContext ctx, CommandLine commandLine, Predicate<CommandType> commandPredicate) {
        List<Object> subcommands = AdminTool.filterCommandProviders(commandProviders, commandGroup).stream().filter(c -> commandPredicate.test(c.commandType())).map(c -> c.createCommand(ctx)).sorted(new CommandNameComparator()).toList();
        for (Object subcommand : subcommands) {
            commandLine.addSubcommand(subcommand);
        }
    }

    protected static Collection<CommandProvider> filterCommandProviders(Collection<CommandProvider> commandProviders, CommandGroup group) {
        return commandProviders.stream().filter(c -> c.commandType().getCommandGroup() == group).filter(c -> SystemUtils.IS_OS_WINDOWS || c.commandType() != CommandType.NEO4J_SERVICE).collect(Collectors.toMap(CommandProvider::commandType, v -> v, (cp1, cp2) -> {
            if (cp1.getPriority() == cp2.getPriority()) {
                throw new IllegalArgumentException(String.format("Command providers %s and %s create commands with the same priority", cp1.getClass(), cp2.getClass()));
            }
            return cp1.getPriority() < cp2.getPriority() ? cp1 : cp2;
        })).values();
    }

    private static Path getHomeDir() {
        String value = System.getenv(ENV_NEO4J_HOME);
        if (StringUtils.isBlank((CharSequence)value)) {
            System.err.printf("Required environment variable '%s' is not set%n", ENV_NEO4J_HOME);
            System.exit(64);
        }
        Path path = Path.of(value, new String[0]).toAbsolutePath();
        AdminTool.checkExistsAndIsDirectory(path, true, ENV_NEO4J_HOME);
        return path;
    }

    private static void checkExistsAndIsDirectory(Path path, boolean mustExist, String envVariable) {
        if (!mustExist && !Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            System.err.printf("%s path doesn't exist or not a directory: %s%n", envVariable, path);
            System.exit(64);
        }
    }

    private static Path getConfDir(Path homeDir) {
        Path path;
        String value = System.getenv(ENV_NEO4J_CONF);
        boolean isExplicitlySet = !StringUtils.isBlank((CharSequence)value);
        Path path2 = path = isExplicitlySet ? Path.of(value, new String[0]).toAbsolutePath() : homeDir.resolve("conf");
        if (isExplicitlySet) {
            AdminTool.checkExistsAndIsDirectory(path, false, ENV_NEO4J_CONF);
        }
        return path;
    }

    private static interface Strategy {
        public AdminTool createRootCommand();

        public void registerCommandsFromGroup(CommandGroup var1, CommandLine var2, Collection<CommandProvider> var3);
    }

    private static class CommandNameComparator
    implements Comparator<Object> {
        private CommandNameComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return this.getCommand(o1).name().compareTo(this.getCommand(o2).name());
        }

        private CommandLine.Command getCommand(Object object) {
            for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                if (!clazz.isAnnotationPresent(CommandLine.Command.class)) continue;
                return clazz.getAnnotation(CommandLine.Command.class);
            }
            throw new IllegalStateException("Instance of " + object.getClass() + " is not a command.");
        }
    }

    @CommandLine.Command(name="version", description={"Print version information and exit."})
    public static class VersionCommand
    implements Callable<Integer> {
        private final ExecutionContext ctx;

        public VersionCommand(ExecutionContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public Integer call() throws Exception {
            this.ctx.out().println("neo4j " + Version.getNeo4jVersion());
            return 0;
        }
    }

    @CommandLine.Command(name="neo4j", description={"A partial alias for 'neo4j-admin server'. Commands for working with DBMS process from 'neo4j-admin server' category can be invoked using this command."})
    public static class Neo4jAlias
    extends AdminTool {
        private static final Set<CommandType> SUPPORTED_COMMANDS = Set.of(CommandType.NEO4J_CONSOLE, CommandType.NEO4J_START, CommandType.NEO4J_RESTART, CommandType.NEO4J_STATUS, CommandType.NEO4J_STOP, CommandType.NEO4J_SERVICE);

        public static CommandLine getCommandLine(final ExecutionContext ctx) {
            return Neo4jAlias.getCommandLine(ctx, new Strategy(){

                @Override
                public AdminTool createRootCommand() {
                    return new Neo4jAlias();
                }

                @Override
                public void registerCommandsFromGroup(CommandGroup commandGroup, CommandLine commandLine, Collection<CommandProvider> commandProviders) {
                    if (commandGroup == CommandGroup.SERVER) {
                        AdminTool.registerGroupCommands(commandProviders, commandGroup, ctx, commandLine, SUPPORTED_COMMANDS::contains);
                    }
                }
            });
        }

        @VisibleForTesting
        public static int execute(ExecutionContext ctx, String ... args) {
            CommandLine cmd = Neo4jAlias.getCommandLine(ctx);
            if (args.length == 0) {
                cmd.usage(cmd.getOut());
                return 2;
            }
            return cmd.execute(args);
        }

        public static void main(String[] args) {
            Path homeDir = AdminTool.getHomeDir();
            Path confDir = AdminTool.getConfDir(homeDir);
            ExecutionContext ctx = new ExecutionContext(homeDir, confDir);
            int exitCode = Neo4jAlias.execute(ctx, args);
            System.exit(exitCode);
        }
    }

    static class VersionProvider
    implements CommandLine.IVersionProvider {
        VersionProvider() {
        }

        public String[] getVersion() {
            return new String[]{Version.getNeo4jVersion()};
        }
    }
}

