/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.FilterMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.util.Version;

public class UpgradeIndexMergePolicy
extends FilterMergePolicy {
    public UpgradeIndexMergePolicy(MergePolicy in) {
        super(in);
    }

    protected boolean shouldUpgradeSegment(SegmentCommitInfo si) {
        return !Version.LATEST.equals(si.info.getVersion());
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.in.findMerges(null, segmentInfos, mergeContext);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        HashMap<SegmentCommitInfo, Boolean> oldSegments = new HashMap<SegmentCommitInfo, Boolean>();
        for (Object si : segmentInfos) {
            Boolean v = segmentsToMerge.get(si);
            if (v == null || !this.shouldUpgradeSegment((SegmentCommitInfo)si)) continue;
            oldSegments.put((SegmentCommitInfo)si, v);
        }
        if (this.verbose(mergeContext)) {
            this.message("findForcedMerges: segmentsToUpgrade=" + oldSegments, mergeContext);
        }
        if (oldSegments.isEmpty()) {
            return null;
        }
        MergePolicy.MergeSpecification spec = this.in.findForcedMerges(segmentInfos, maxSegmentCount, oldSegments, mergeContext);
        if (spec != null) {
            for (MergePolicy.OneMerge om : spec.merges) {
                om.segments.forEach(oldSegments::remove);
            }
        }
        if (!oldSegments.isEmpty()) {
            if (this.verbose(mergeContext)) {
                this.message("findForcedMerges: " + this.in.getClass().getSimpleName() + " does not want to merge all old segments, merge remaining ones into new segment: " + oldSegments, mergeContext);
            }
            ArrayList<SegmentCommitInfo> newInfos = new ArrayList<SegmentCommitInfo>();
            for (SegmentCommitInfo si : segmentInfos) {
                if (!oldSegments.containsKey(si)) continue;
                newInfos.add(si);
            }
            if (spec == null) {
                spec = new MergePolicy.MergeSpecification();
            }
            spec.add(new MergePolicy.OneMerge(newInfos));
        }
        return spec;
    }
}

