/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export.aura;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.export.aura.AuraConsole;

public class AuraURLFactory {
    public AuraConsole buildConsoleURI(String boltURI, boolean devMode) throws CommandFailedException {
        ConsoleUrlMatcher[] consoleUrlMatcherArray;
        if (devMode) {
            ConsoleUrlMatcher[] consoleUrlMatcherArray2 = new ConsoleUrlMatcher[3];
            consoleUrlMatcherArray2[0] = new ConsoleUrlMatcher.DevMatcher();
            consoleUrlMatcherArray2[1] = new ConsoleUrlMatcher.ProdMatcher();
            consoleUrlMatcherArray = consoleUrlMatcherArray2;
            consoleUrlMatcherArray2[2] = new ConsoleUrlMatcher.PrivMatcher();
        } else {
            ConsoleUrlMatcher[] consoleUrlMatcherArray3 = new ConsoleUrlMatcher[2];
            consoleUrlMatcherArray3[0] = new ConsoleUrlMatcher.ProdMatcher();
            consoleUrlMatcherArray = consoleUrlMatcherArray3;
            consoleUrlMatcherArray3[1] = new ConsoleUrlMatcher.PrivMatcher();
        }
        ConsoleUrlMatcher[] matchers = consoleUrlMatcherArray;
        return Arrays.stream(matchers).filter(m -> m.match(boltURI)).findFirst().orElseThrow(() -> new CommandFailedException("Invalid Bolt URI '" + boltURI + "'")).getConsole();
    }

    static abstract class ConsoleUrlMatcher {
        protected Matcher matcher;
        protected String url;

        ConsoleUrlMatcher() {
        }

        protected abstract Pattern pattern();

        public abstract AuraConsole getConsole();

        public boolean match(String url) {
            this.url = url;
            this.matcher = this.pattern().matcher(url);
            return this.matcher.matches();
        }

        static class PrivMatcher
        extends ConsoleUrlMatcher {
            PrivMatcher() {
            }

            @Override
            protected Pattern pattern() {
                return Pattern.compile("(?:bolt(?:\\+routing)?|neo4j(?:\\+s|\\+ssc)?)://([a-zA-Z0-9]+)\\.(\\S+)-orch-(\\d+).neo4j(-\\S+)?.io$");
            }

            @Override
            public AuraConsole getConsole() {
                String databaseId = this.matcher.group(1);
                Object environment = this.matcher.group(2);
                String domain = "";
                switch (environment) {
                    case "production": {
                        environment = "";
                        break;
                    }
                    case "staging": {
                        environment = "-" + (String)environment;
                        break;
                    }
                    default: {
                        environment = "-" + (String)environment;
                        if (this.matcher.group(4) == null) {
                            throw new CommandFailedException("Invalid Bolt URI '" + this.url + "'");
                        }
                        domain = this.matcher.group(4);
                    }
                }
                String baseURL = String.format("https://console%s.neo4j%s.io", environment, domain);
                return new AuraConsole(baseURL, databaseId);
            }
        }

        static class DevMatcher
        extends ConsoleUrlMatcher {
            DevMatcher() {
            }

            @Override
            protected Pattern pattern() {
                return Pattern.compile("(?:bolt(?:\\+routing)?|neo4j(?:\\+s|\\+ssc)?)://([^-]+)(-(.+))?.databases.neo4j(-(.+))?.io$");
            }

            @Override
            public AuraConsole getConsole() {
                String databaseId = this.matcher.group(1);
                String environment = this.matcher.group(2);
                String domain = "";
                if (environment == null) {
                    throw new CommandFailedException("Expected to find an environment running in dev mode in bolt URI: " + this.url);
                }
                if (this.matcher.groupCount() == 5) {
                    domain = this.matcher.group(4);
                }
                String baseURL = String.format("https://console%s.neo4j%s.io", environment, domain);
                return new AuraConsole(baseURL, databaseId);
            }
        }

        static class ProdMatcher
        extends ConsoleUrlMatcher {
            ProdMatcher() {
            }

            @Override
            protected Pattern pattern() {
                return Pattern.compile("(?:bolt(?:\\+routing)?|neo4j(?:\\+s|\\+ssc)?)://([^-]+)(-(.+))?.databases.neo4j.io$");
            }

            @Override
            public AuraConsole getConsole() {
                String databaseId = this.matcher.group(1);
                String environment = this.matcher.group(2);
                return new AuraConsole(String.format("https://console%s.neo4j.io", environment == null ? "" : environment), databaseId);
            }
        }
    }
}

